package com.biz.crm.tpm.business.marketing.strategy.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:营销策络主列表明细导出
 * @Author qiancheng
 * @Date 2023/8/25
 */
@Component
public class MarketStrategyItemExportProcess implements ExportProcess<MarketStrategyItemExportVo> {

    @Autowired(required = false)
    private MarketingStrategyItemService itemService;

    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;


    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        MarketingStrategyItemDto marketingStrategyItemDto = this.convertParams(params);
        marketingStrategyItemDto.setTenantCode(TenantUtils.getTenantCode());
        Integer total = itemService.itemExportGetTotal(marketingStrategyItemDto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        MarketingStrategyItemDto marketingStrategyItemDto = this.convertParams(params);
        marketingStrategyItemDto.setTenantCode(TenantUtils.getTenantCode());
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        Page<MarketStrategyItemExportVo> page = itemService.itemExportGetDate(pageable,marketingStrategyItemDto);
        if (page.getSize() == 0 || CollectionUtils.isEmpty(page.getRecords())) {
            return new JSONArray();
        }
        List<MarketStrategyItemExportVo> records = page.getRecords();
        //调整
        adjustData(records);
        return JSON.parseArray(JSON.toJSONString(records));
    }

    private void adjustData(List<MarketStrategyItemExportVo> dataList) {
        //  获取系统
        Map<String, String> sysMap = this.customerRetailerVoService.getAllRetailerCode();
        //费用归口
        Map<String, String> feeMap = dictToolkitService.findMapByDictTypeCode(MarketingStrategyConstant.DICT_TPM_FEE_BELONG_US);
        //策略类型
        Map<String, String> typeMap = dictToolkitService.findMapByDictTypeCode(MarketingStrategyConstant.DICT_TPM_MARKETING_STRATEGY_TYPE);
        for (MarketStrategyItemExportVo vo : dataList) {
            if (StringUtils.isNotBlank(vo.getSystemCode())) {
                vo.setSystemCode(sysMap.getOrDefault(vo.getSystemCode(), vo.getSystemCode()));
            }
            if (StringUtils.isNotBlank(vo.getFeeBelongCode())) {
                vo.setFeeBelongCode(feeMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
            }
            if (StringUtils.isNotBlank(vo.getStrategyType())) {
                vo.setStrategyType(typeMap.getOrDefault(vo.getStrategyType(), vo.getStrategyType()));
            }
            if (StringUtils.isNotBlank(vo.getProcessStatus())) {
                String processStatus = ProcessStatusEnum.getStatusNameByKey(vo.getProcessStatus());
                vo.setProcessStatus(processStatus);
            }
        }
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MARKET_STRATEGY_ITEM_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "营销策略明细导出";
    }

    private MarketingStrategyItemDto convertParams(Map<String, Object> params) {
        Map<String, Object> map = params.entrySet().stream()
                .collect(Collectors.toMap(e -> e.getKey(), Map.Entry::getValue));
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        MarketingStrategyItemDto dto = JSON.parseObject(JSON.toJSONString(map), MarketingStrategyItemDto.class);
        return dto;
    }
}
