package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgRangeDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyItemDY00000008ImportVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 营销策略导入服务-主体
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class MarketingStrategyDY00000008ImportsProcess implements ImportProcess<MarketingStrategyItemDY00000008ImportVo> {

    @Autowired
    private MarketingStrategyService marketingStrategyService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;

    private static final String yesOrNo = "yesOrNo";

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyItemDY00000008ImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Map<Integer, String> errorMap = Maps.newHashMap();
        Map<Integer, List<String>> errorListMap = Maps.newHashMap();
        try {
            List<MarketingStrategyItemDY00000008ImportVo> importVos = Lists.newArrayList(data.values());

            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(MarketingStrategyConstant.DICT_MDM_BUSINESS_FORMAT);
            dictCodeList.add(MarketingStrategyConstant.DICT_MDM_BUSINESS_UNIT);
            dictCodeList.add(MarketingStrategyConstant.DICT_TPM_MARKETING_STRATEGY_TYPE);
            dictCodeList.add(yesOrNo);
            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode,(o,n)->n)),(o,n)->n));

            List<DictDataVo> businessFormatList = dictMap.get(MarketingStrategyConstant.DICT_MDM_BUSINESS_FORMAT);
            Map<String, String> businessFormatMap = businessFormatList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n));
            List<DictDataVo> businessUnitList = dictMap.get(MarketingStrategyConstant.DICT_MDM_BUSINESS_UNIT);
            Map<String, String> businessUnitMap = businessUnitList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n));
            List<DictDataVo> strategyTypeList = dictMap.get(MarketingStrategyConstant.DICT_TPM_MARKETING_STRATEGY_TYPE);
            Map<String, String> strategyTypeMap = strategyTypeList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n));

            Set<String> orgCodeSet = Sets.newHashSet();
            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            Set<String> salesInstitutionCodeSet = Sets.newHashSet();

            int key = 0;
            for (MarketingStrategyItemDY00000008ImportVo importVo : importVos) {
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
                if (StringUtils.isEmpty(importVo.getBusinessFormatCode())){errorList.add("业态不能为空");}
                String businessFormatCode = businessFormatMap.get(importVo.getBusinessFormatCode());
                if (StringUtils.isEmpty(businessFormatCode)){
                    if (StringUtils.isEmpty(importVo.getBusinessFormatCode())){errorList.add("业态["+importVo.getBusinessFormatCode()+"]有误");}
                }
                if (StringUtils.isEmpty(importVo.getBusinessUnitCode())){errorList.add("业务单元不能为空");}
                if (StringUtils.isEmpty(importVo.getStrategyType())){errorList.add("策略类型不能为空");}
                if (StringUtils.isEmpty(importVo.getStrategyOrgCode())){errorList.add("区域编码不能为空");}
                if (StringUtils.isEmpty(importVo.getSalesInstitutionCode())){errorList.add("销售机构编码不能为空");}
                if (StringUtils.isEmpty(importVo.getChannelCode())){errorList.add("渠道编码不能为空");}

                if (StringUtils.isNotEmpty(importVo.getAttrOrgCode())){
                    orgCodeSet.add(importVo.getAttrOrgCode());
                }
//                if (StringUtils.isNotEmpty(importVo.getStrategyOrgCode())){
//                    salesOrgCodeSet.add(importVo.getStrategyOrgCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getStrategyOrgCode())){
                    salesOrgCodeSet.add(importVo.getStrategyOrgCode());
                }
                if(StringUtils.isNotEmpty(importVo.getChannelCode()) && StringUtils.isNotEmpty(businessFormatCode) && StringUtils.isNotEmpty(importVo.getSalesInstitutionCode())){
                    salesInstitutionCodeSet.add(importVo.getChannelCode()+businessFormatCode+importVo.getSalesInstitutionCode());
                }

                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())){
                    activityTypeCodeSet.addAll(Arrays.asList(importVo.getActivityTypeCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    activityFormCodeSet.addAll(Arrays.asList(importVo.getActivityFormCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
                    terminalChannelSet.addAll(Arrays.asList(importVo.getFirstChannelCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
                    terminalChannelSet.addAll(Arrays.asList(importVo.getSecondChannelCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                key++;
            }

            Map<String,String> orgMap = Maps.newHashMap();
//            Map<String,String> salesOrgMap = Maps.newHashMap();
            Map<String,Map<String,SalesOrgVo>> salesOrgMap = Maps.newHashMap();
            Map<String,String> activityTypeMap = Maps.newHashMap();
            Map<String,String> activityFormMap = Maps.newHashMap();
            Map<String,MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String,String> terminalChannelMap = Maps.newHashMap();
            Map<String,String> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(orgCodeSet)){
                List<OrgVo> orgList = orgVoService.findByOrgCodes(Lists.newArrayList(orgCodeSet));
                orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode,OrgVo::getOrgName));
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
                SalesOrgRangeDto rangeDto = new SalesOrgRangeDto();
                rangeDto.setErpCodes(new ArrayList<>(salesOrgCodeSet));
                rangeDto.setSalesInstitutionCodes(new ArrayList<>(salesInstitutionCodeSet));
                salesOrgMap = salesOrgVoService.findMapBySalesOrgErpCodesAndInsCodes(rangeDto);
            }
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)){
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,ActivityTypeVo::getActivityTypeName));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)){
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<List<String>> activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = activityFormService.findFormByCodes(activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty(terminalChannelSet)){
                List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode,MdmTerminalChannelVo::getTerminalChannelName));
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)){
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode,ProductBrandVo::getProductBrandName));
            }

            List<MarketingStrategyItemDto> dtos = Lists.newArrayList();
            key = 0;
            for (MarketingStrategyItemDY00000008ImportVo importVo : importVos) {
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());

                MarketingStrategyItemDto item = nebulaToolkitService.copyObjectByWhiteList(importVo, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class);

                String businessFormatCode = businessFormatMap.get(importVo.getBusinessFormatCode());
                if (StringUtils.isEmpty(businessFormatCode)){
                    errorList.add("业态["+importVo.getBusinessFormatCode()+"]有误");
                }else{
                    item.setBusinessFormatCode(businessFormatCode);
                }

                String businessUnitCode = businessUnitMap.get(importVo.getBusinessUnitCode());
                if (StringUtils.isEmpty(businessUnitCode)){
                    errorList.add("业务单元["+importVo.getBusinessUnitCode()+"]有误");
                }else{
                    item.setBusinessUnitCode(businessUnitCode);
                }


                String strategyType = strategyTypeMap.get(importVo.getStrategyType());
                if (StringUtils.isEmpty(strategyType)){
                    errorList.add("策略类型["+importVo.getStrategyType()+"]有误");
                }else{
                    item.setStrategyType(strategyType);
                }

                validateAndConvertDictData(dictMapMap,yesOrNo,importVo.getIsCrossMonth(),item::setIsCrossMonth,"是否跨月策略",errorList);
                validateDateStrAndSet(importVo.getBeginDateStr(),"新增时，策略明细开始时间不能为空", true, DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setBeginDate,errorList);
                validateDateStrAndSet(importVo.getEndDateStr(),"新增时，策略明细结束时间不能为空", true,DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setEndDate,errorList);

                //归属部门
                if (StringUtils.isNotEmpty(importVo.getAttrOrgCode())){
                    String attrOrgName = orgMap.get(importVo.getAttrOrgCode());
                    if (StringUtils.isEmpty(attrOrgName)){
                        errorList.add("归属部门["+importVo.getAttrOrgCode()+"]有误");
                    }else{
                        item.setAttrOrgName(attrOrgName);
                    }
                }

                //区域
                strategyOrgCode:if (StringUtils.isNotEmpty(importVo.getStrategyOrgCode())) {
                    Map<String, SalesOrgVo> voMap = salesOrgMap.get(importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode());
                    if (null == voMap) {
                        errorList.add("分销渠道["+importVo.getChannelCode()+"]销售组织[" + importVo.getSalesInstitutionCode() + "]未匹配");
                        break strategyOrgCode;
                    }
                    if (voMap.isEmpty()) {
                        errorList.add("区域[" + importVo.getStrategyOrgCode() + "]有误");
                        break strategyOrgCode;
                    }
                    SalesOrgVo orgVo = voMap.get(importVo.getStrategyOrgCode());
                    if (Objects.isNull(orgVo)) {
                        errorList.add("区域[" + importVo.getStrategyOrgCode() + "]有误");
                        break strategyOrgCode;
                    }
                    item.setStrategyOrgName(orgVo.getSalesOrgName());
                    item.setStrategyOrgCode(orgVo.getSalesOrgCode());
                    item.setStrategyOrgErpCode(orgVo.getErpCode());
                }

                //活动分类
                activityType:if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            errorList.add("活动分类[" + code + "]有误");
                            break activityType;
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    item.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                activityForm:if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityFormName = activityFormMap.get(code);
                        if (StringUtils.isEmpty(activityFormName)) {
                            errorList.add("活动形式[" + code + "]有误");
                            break activityForm;
                        } else {
                            allNames.add(activityFormName);
                        }
                    }
                    item.setActivityFormName(String.join(",", allNames));
                }

                //月度预算
                monthBudget:if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo){
                        errorList.add("月度预算["+importVo.getMonthBudgetCode()+"]有误");
                        break monthBudget;
                    }
                    if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())){
                        errorList.add("月度预算["+monthBudgetVo.getMonthBudgetCode()+"],必须为部门分组");
                        break monthBudget;
                    }
                    item.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                    item.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());
                }

                //一级渠道
                firstChannel:if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
                    String[] codes = importVo.getFirstChannelCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String terminalChannelName = terminalChannelMap.get(code);
                        if (StringUtils.isEmpty(terminalChannelName)){
                            errorList.add("一级渠道["+importVo.getFirstChannelCode()+"]有误");
                            break firstChannel;
                        }
                        allNames.add(terminalChannelName);
                    }
                    item.setFirstChannelName(String.join(",", allNames));
                }

                //二级渠道
                secondChannel:if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
                    String[] codes = importVo.getSecondChannelCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String terminalChannelName = terminalChannelMap.get(code);
                        if (StringUtils.isEmpty(terminalChannelName)){
                            errorList.add("二级渠道["+importVo.getSecondChannelCode()+"]有误");
                            break secondChannel;
                        }
                        allNames.add(terminalChannelName);
                    }
                    item.setSecondChannelName(String.join(",", allNames));
                }

                //品牌
                productBrand:if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    String brandName = productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty(brandName)){
                        errorList.add("品牌["+importVo.getProductBrandCode()+"]有误");
                        break productBrand;
                    }
                    item.setProductBrandName(brandName);
                }
                item.setId(UUID.randomUUID().toString().replace("-", ""));
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dtos.add(item);
            }




            if (errorListMap.size() > 0){
                log.error("===========================方案导入，错误信息" + JSON.toJSONString(errorListMap));
                for (Map.Entry<Integer, List<String>> entry : errorListMap.entrySet()) {
                    List<String> value = entry.getValue();
                    if (value.size() > 0){
                        errorMap.put(entry.getKey(),String.join(",",value));
                    }
                }
            }

            if (errorMap.size() == 0){
                //按业态、业务单位、策略类型分组
                Map<String, List<MarketingStrategyItemDto>> strategyMap = dtos.stream().collect(Collectors.groupingBy(item -> {
                    return item.getBusinessFormatCode() + item.getBusinessUnitCode() + item.getStrategyType();
                }));
                for (Map.Entry<String, List<MarketingStrategyItemDto>> entry : strategyMap.entrySet()) {
                    List<MarketingStrategyItemDto> value = entry.getValue();
                    MarketingStrategyItemDto firstData = value.get(0);
                    MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
                    marketingStrategyDto.setBusinessFormatCode(firstData.getBusinessFormatCode());
                    marketingStrategyDto.setBusinessUnitCode(firstData.getBusinessUnitCode());
                    marketingStrategyDto.setStrategyType(firstData.getStrategyType());
                    marketingStrategyService.saveMutiMarketingStrategy(marketingStrategyDto,value);
                }
            }
        }catch (RuntimeException e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc, List<String> errorList){
        try {
            validateAndConvertDictData(dictMap,dictTypeCode,dictValue,setMethod,desc);
        }catch (RuntimeException e){
            errorList.add(e.getMessage());
        }
    }

    private void validateDateStrAndSet(String str, String desc, boolean required,String pattern, Consumer<Date> setMethod,List<String> errorList){
        try {
            DateStringDealUtil.validateDateStrAndSet(str, desc, required, pattern, setMethod);
        }catch (RuntimeException e){
            errorList.add(e.getMessage());
        }
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc){
        if (StringUtils.isEmpty(dictValue)){
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)){
            throw new RuntimeException(desc+"["+dictValue+"]有误");
        }
        setMethod.accept(dictCode);
    }

    @Override
    public Class<MarketingStrategyItemDY00000008ImportVo> findCrmExcelVoClass() {
        return MarketingStrategyItemDY00000008ImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT_DY00000008";
    }

    @Override
    public String getTemplateName() {
        return "TPM-营销策略导入-主体";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-营销策略导入";
    }

}
