package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyItemDY00000010ImportVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 营销策略导入服务-垂直
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class MarketingStrategyDY00000010ImportsProcess implements ImportProcess<MarketingStrategyItemDY00000010ImportVo> {

    @Autowired
    private MarketingStrategyService marketingStrategyService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyItemDY00000010ImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            List<MarketingStrategyItemDY00000010ImportVo> importVos = Lists.newArrayList(data.values());

            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(MarketingStrategyConstant.DICT_MDM_BUSINESS_FORMAT);
            dictCodeList.add(MarketingStrategyConstant.DICT_MDM_BUSINESS_UNIT);
            dictCodeList.add(MarketingStrategyConstant.DICT_TPM_MARKETING_STRATEGY_TYPE);
            dictCodeList.add(MarketingStrategyConstant.DICT_MDM_CUSTOMIZE_ORG);
            dictCodeList.add(MarketingStrategyConstant.DICT_FIRST_CHANNEL_NAME);
            dictCodeList.add(MarketingStrategyConstant.DICT_SECOND_CHANNEL_CODE);
            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
             Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode,(o,n)->n)),(o,n)->n));

            Set<String> orgCodeSet = Sets.newHashSet();
            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> terminalChannelSet = Sets.newHashSet();
            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();
            for (MarketingStrategyItemDY00000010ImportVo importVo : importVos) {
                Validate.notBlank(importVo.getBusinessFormatCode(),"业态不能为空");
                Validate.notBlank(importVo.getBusinessUnitCode(),"业务单元不能为空");
                Validate.notBlank(importVo.getStrategyType(),"策略类型不能为空");

                if (StringUtils.isNotEmpty(importVo.getAttrOrgCode())){
                    orgCodeSet.add(importVo.getAttrOrgCode());
                }
//                if (StringUtils.isNotEmpty(importVo.getStrategyOrgCode())){
//                    salesOrgCodeSet.add(importVo.getStrategyOrgCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())){
                    activityTypeCodeSet.addAll(Arrays.asList(importVo.getActivityTypeCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    activityFormCodeSet.addAll(Arrays.asList(importVo.getActivityFormCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getRegionAutomaticMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getRegionAutomaticMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getRegionReferendumMonthBudgetCode())){
                    monthBudgetCodeSet.add(importVo.getRegionReferendumMonthBudgetCode());
                }
//                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
//                    terminalChannelSet.add(importVo.getFirstChannelCode());
//                }
//                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
//                    terminalChannelSet.add(importVo.getSecondChannelCode());
//                }
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
            }

            Map<String,String> orgMap = Maps.newHashMap();
            Map<String,String> salesOrgMap = Maps.newHashMap();
            Map<String,String> activityTypeMap = Maps.newHashMap();
            Map<String,String> activityFormMap = Maps.newHashMap();
            Map<String,MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String,String> terminalChannelMap = Maps.newHashMap();
            Map<String,String> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(orgCodeSet)){
                List<OrgVo> orgList = orgVoService.findByOrgCodes(Lists.newArrayList(orgCodeSet));
                orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode,OrgVo::getOrgName));
            }
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)){
                List<SalesOrgVo> salesOrgList = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
                if (!CollectionUtils.isEmpty(salesOrgList)){
                    salesOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode,SalesOrgVo::getSalesOrgName));
                }
            }
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)){
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode,ActivityTypeVo::getActivityTypeName));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)){
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<List<String>> activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = activityFormService.findFormByCodes(activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            }
//            if (!CollectionUtils.isEmpty(terminalChannelSet)){
//                List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
//                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode,MdmTerminalChannelVo::getTerminalChannelName));
//            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)){
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode,ProductBrandVo::getProductBrandName,(o,n) -> n));
            }

            List<MarketingStrategyItemDto> dtos = Lists.newArrayList();
            for (MarketingStrategyItemDY00000010ImportVo importVo : importVos) {
                MarketingStrategyItemDto item = nebulaToolkitService.copyObjectByWhiteList(importVo, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class);

                validateAndConvertDictData(dictMapMap,MarketingStrategyConstant.DICT_MDM_BUSINESS_FORMAT,importVo.getBusinessFormatCode(),item::setBusinessFormatCode,"业态");
                validateAndConvertDictData(dictMapMap,MarketingStrategyConstant.DICT_MDM_BUSINESS_UNIT,importVo.getBusinessUnitCode(),item::setBusinessUnitCode,"业务单元");
                validateAndConvertDictData(dictMapMap,MarketingStrategyConstant.DICT_TPM_MARKETING_STRATEGY_TYPE,importVo.getStrategyType(),item::setStrategyType,"策略类型");
                validateAndConvertDictData(dictMapMap,MarketingStrategyConstant.DICT_MDM_CUSTOMIZE_ORG,importVo.getRegion(),item::setRegion,"区域");
                validateAndConvertDictData(dictMapMap,MarketingStrategyConstant.DICT_FIRST_CHANNEL_NAME,importVo.getFirstChannelName(),item::setFirstChannelCode,"一级渠道名称");
                validateAndConvertDictData(dictMapMap,MarketingStrategyConstant.DICT_SECOND_CHANNEL_CODE,importVo.getSecondChannelName(),item::setSecondChannelCode,"二级渠道名称");

                //归属部门
                if (StringUtils.isNotEmpty(importVo.getAttrOrgCode())){
                    String attrOrgName = orgMap.get(importVo.getAttrOrgCode());
                    if (StringUtils.isEmpty(attrOrgName)){
                        throw new RuntimeException("归属部门["+importVo.getAttrOrgCode()+"]有误");
                    }
                    item.setAttrOrgName(attrOrgName);
                }

                //区域
//                if (StringUtils.isNotEmpty(importVo.getStrategyOrgCode())){
//                    String strategyOrgName = salesOrgMap.get(importVo.getStrategyOrgCode());
//                    if (StringUtils.isEmpty(strategyOrgName)){
//                        throw new RuntimeException("区域["+importVo.getStrategyOrgCode()+"]有误");
//                    }
//                    item.setStrategyOrgName(strategyOrgName);
//                }

                //活动分类
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            throw new RuntimeException("活动分类[" + code + "]有误");
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    item.setActivityTypeName(String.join(",", allNames));
                }

                //活动形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())){
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityFormName = activityFormMap.get(code);
                        if (StringUtils.isEmpty(activityFormName)) {
                            throw new RuntimeException("活动形式[" + code + "]有误");
                        } else {
                            allNames.add(activityFormName);
                        }
                    }
                    item.setActivityFormName(String.join(",", allNames));
                }

                List<MarketingStrategyBudgetDto> budgetShares = Lists.newArrayList();
                item.setBudgetShares(budgetShares);
                //月度预算
                if (StringUtils.isNotEmpty(importVo.getHeadMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo){
                        throw new RuntimeException("月度预算["+importVo.getHeadMonthBudgetCode()+"]有误");
                    }
                    item.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item.setHeadBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());

                    MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties(monthBudgetVo,budgetDto);
                    try {
                        budgetDto.setUseAmountStr(importVo.getHeadFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getHeadFeeAmountStr()));
                    }catch (Exception e){
                        throw new RuntimeException("总部费用格式有误!");
                    }
                    budgetShares.add(budgetDto);
                }
                //月度预算
                if (StringUtils.isNotEmpty(importVo.getRegionReferendumMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getRegionReferendumMonthBudgetCode());
                    if (null == monthBudgetVo){
                        throw new RuntimeException("月度预算["+importVo.getRegionReferendumMonthBudgetCode()+"]有误");
                    }
                    item.setRegionReferendumBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item.setRegionReferendumBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());

                    MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties(monthBudgetVo,budgetDto);
                    try {
                        budgetDto.setUseAmountStr(importVo.getRegionReferendumFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getRegionReferendumFeeAmountStr()));
                    }catch (Exception e){
                        throw new RuntimeException("公投费用格式有误!");
                    }
                    budgetShares.add(budgetDto);
                }

                //月度预算
                if (StringUtils.isNotEmpty(importVo.getRegionAutomaticMonthBudgetCode())){
                    MonthBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getRegionAutomaticMonthBudgetCode());
                    if (null == monthBudgetVo){
                        throw new RuntimeException("月度预算["+importVo.getRegionAutomaticMonthBudgetCode()+"]有误");
                    }
                    item.setRegionAutomaticBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item.setRegionAutomaticBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    item.setStrategyYearMonth(monthBudgetVo.getYearMonthLy());

                    MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties(monthBudgetVo,budgetDto);
                    try {
                        budgetDto.setUseAmountStr(importVo.getRegionAutomaticFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getRegionAutomaticFeeAmountStr()));
                    }catch (Exception e){
                        throw new RuntimeException("公投费用格式有误!");
                    }
                    budgetShares.add(budgetDto);
                }

                //一级渠道
//                if (StringUtils.isNotEmpty(importVo.getFirstChannelCode())){
//                    String terminalChannelName = terminalChannelMap.get(importVo.getFirstChannelCode());
//                    if (StringUtils.isEmpty(terminalChannelName)){
//                        throw new RuntimeException("一级渠道["+importVo.getFirstChannelCode()+"]有误");
//                    }
//                    item.setFirstChannelName(terminalChannelName);
//                }
//
//                //二级渠道
//                if (StringUtils.isNotEmpty(importVo.getSecondChannelCode())){
//                    String terminalChannelName = terminalChannelMap.get(importVo.getSecondChannelCode());
//                    if (StringUtils.isEmpty(terminalChannelName)){
//                        throw new RuntimeException("二级渠道["+importVo.getSecondChannelCode()+"]有误");
//                    }
//                    item.setSecondChannelName(terminalChannelName);
//                }

                //品牌
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())){
                    String brandName = productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty(brandName)){
                        throw new RuntimeException("品牌["+importVo.getProductBrandCode()+"]有误");
                    }
                    item.setProductBrandName(brandName);
                }
                dtos.add(item);
            }

            //按业态、业务单位、策略类型分组
            Map<String, List<MarketingStrategyItemDto>> strategyMap = dtos.stream().collect(Collectors.groupingBy(item -> {
                return item.getBusinessFormatCode() + item.getBusinessUnitCode() + item.getStrategyType();
            }));
            for (Map.Entry<String, List<MarketingStrategyItemDto>> entry : strategyMap.entrySet()) {
                List<MarketingStrategyItemDto> value = entry.getValue();
                MarketingStrategyItemDto firstData = value.get(0);
                MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
                marketingStrategyDto.setBusinessFormatCode(firstData.getBusinessFormatCode());
                marketingStrategyDto.setBusinessUnitCode(firstData.getBusinessUnitCode());
                marketingStrategyDto.setStrategyType(firstData.getStrategyType());
                marketingStrategyService.saveMutiMarketingStrategy(marketingStrategyDto,value);
            }
        }catch (RuntimeException e){
            log.error(e.getMessage(),e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())){
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    public void validateAndConvertDictData(Map<String, Map<String,String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc){
        if (StringUtils.isEmpty(dictValue)){
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)){
            throw new RuntimeException(desc+"["+dictValue+"]有误");
        }
        setMethod.accept(dictCode);
    }


    @Override
    public Class<MarketingStrategyItemDY00000010ImportVo> findCrmExcelVoClass() {
        return MarketingStrategyItemDY00000010ImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT_DY00000010";
    }

    @Override
    public String getTemplateName() {
        return "TPM-营销策略导入-垂直";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-营销策略导入";
    }

}
