package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyDy00000010ItemImportVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.swing.text.html.Option;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 营销策略明细导入服务-垂直
 *
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class MarketingStrategyDY00000010ItemImportProcess implements ImportProcess<MarketingStrategyDy00000010ItemImportVo> {

    @Autowired
    private MarketingStrategyItemService marketingStrategyItemService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private ActivityTypeService activityTypeService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;
    @Autowired(required = false)
    private ProductBrandService productBrandService;
    @Autowired(required = false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;


    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyDy00000010ItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Object businessFormatCodeObj = params.get("businessFormatCode");
        if (null == businessFormatCodeObj) {
            throw new RuntimeException("业态不能为空!");
        }
        String businessFormatCode = String.valueOf(businessFormatCodeObj);
        Object businessUnitCodeObj = params.get("businessUnitCode");
        if (null == businessUnitCodeObj) {
            throw new RuntimeException("业务单元不能为空!");
        }
        String cacheKey = String.valueOf(params.get("cacheKey"));

        Map<Integer, String> errorMap = Maps.newHashMap();
        Map<Integer, List<String>> errorListMap = Maps.newHashMap();


        try {
            List<String> dictCodeList = Lists.newArrayList();
            dictCodeList.add(MarketingStrategyConstant.DICT_MDM_CUSTOMIZE_ORG);
//        dictCodeList.add(MarketingStrategyConstant.DICT_FIRST_CHANNEL_NAME);
//        dictCodeList.add(MarketingStrategyConstant.DICT_SECOND_CHANNEL_CODE);
            Map<String, List<DictDataVo>> dictMap = dictDataVoService.findByDictTypeCodeList(dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));


            Set<String> productBrandCodeSet = Sets.newHashSet();
            Set<String> productLevelCodeSet = Sets.newHashSet();
            Set<String> productCodeSet = Sets.newHashSet();
            Set<String> salesOrgCodeSet = Sets.newHashSet();

            Set<String> activityTypeCodeSet = Sets.newHashSet();
            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> customerRetailerNameSet = Sets.newHashSet();

            for (Map.Entry<Integer, MarketingStrategyDy00000010ItemImportVo> entry : data.entrySet()) {
                int key = entry.getKey();
                MarketingStrategyDy00000010ItemImportVo importVo = entry.getValue();
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());

                if (StringUtils.isNotEmpty(importVo.getStrategyOrgErpCode())) {
                    if (StringUtils.isEmpty(importVo.getDistributionChannelCode())) {
                        errorList.add("导入销售组织时分销渠道不能为空！");
                    }
                    String salesOrgCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getStrategyOrgErpCode();
                    salesOrgCodeSet.add(salesOrgCode);
                }
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    activityTypeCodeSet.addAll(Arrays.asList(importVo.getActivityTypeCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    activityFormCodeSet.addAll(Arrays.asList(importVo.getActivityFormCode().split(",")));
                }
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCode())) {
                    productCodeSet.add(importVo.getProductCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (StringUtils.isNotEmpty(importVo.getSystemName())) {
                    customerRetailerNameSet.addAll(Arrays.asList(importVo.getSystemName().replace("，", ",").split(",")));
                }
            }

            Map<String, SalesOrgVo> salesOrgMap = Maps.newHashMap();
            Map<String, String> activityTypeMap = Maps.newHashMap();
            Map<String, String> activityFormMap = Maps.newHashMap();
            Map<String, YearBudgetVo> monthBudgetMap = Maps.newHashMap();
            Map<String, String> productBrandMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
                List<SalesOrgVo> salesOrgList = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
                if (!CollectionUtils.isEmpty(salesOrgList)) {
                    salesOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
                }
            }
            if (!CollectionUtils.isEmpty(activityTypeCodeSet)) {
                List<ActivityTypeVo> activityTypeList = activityTypeService.findByCodes(Lists.newArrayList(activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName));
            }
            if (!CollectionUtils.isEmpty(activityFormCodeSet)) {
                List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
                List<List<String>> activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = activityFormService.findFormByCodes(activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
                List<YearBudgetVo> yearBudgetCodes = yearBudgetSdkService.findByYearBudgetCodes(Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = yearBudgetCodes.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
                List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(Lists.newArrayList(productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }

            Map<String, String> productCategoryMap = Maps.newHashMap();
            Map<String, String> productItemMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productLevelCodeSet)) {
                List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, Lists.newArrayList(productLevelCodeSet));
                List<ProductLevelVo> productCategoryList = productLevelVos.stream().filter(item -> ProductLevelEnum.category.equals(item.getProductLevelType())).collect(Collectors.toList());
                productCategoryMap = productCategoryList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
                List<ProductLevelVo> productItemList = productLevelVos.stream().filter(item -> ProductLevelEnum.items.equals(item.getProductLevelType())).collect(Collectors.toList());
                productItemMap = productItemList.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            Map<String, ProductVo> productMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productCodeSet)) {
                List<ProductVo> productVos = productVoService.findByCodes(Lists.newArrayList(productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
            Map<String, String> systemMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(customerRetailerNameSet)) {
                List<CustomerRetailerVo> customerRetailerVos = customerRetailerVoService.findByNames(Lists.newArrayList(customerRetailerNameSet));
                if (!CollectionUtils.isEmpty(customerRetailerVos)) {
                    systemMap = customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerName, CustomerRetailerVo::getCustomerRetailerCode, (o, n) -> n));
                }
            }

            List<MarketingStrategyItemDto> dtos = Lists.newArrayList();

            for (Map.Entry<Integer, MarketingStrategyDy00000010ItemImportVo> entry : data.entrySet()) {
                int key = entry.getKey();
                List<String> errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());

                MarketingStrategyDy00000010ItemImportVo importVo = entry.getValue();
                MarketingStrategyItemDto item = nebulaToolkitService.copyObjectByWhiteList(importVo, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class);

                validateAndConvertDictData(dictMapMap, MarketingStrategyConstant.DICT_MDM_CUSTOMIZE_ORG, importVo.getRegionName(), item::setRegion, "区域");
//            validateAndConvertDictData(dictMapMap, MarketingStrategyConstant.DICT_FIRST_CHANNEL_NAME, importVo.getFirstChannelName(), item::setFirstChannelCode, "一级渠道名称");
//            validateAndConvertDictData(dictMapMap, MarketingStrategyConstant.DICT_SECOND_CHANNEL_CODE, importVo.getSecondChannelName(), item::setSecondChannelCode, "二级渠道名称");

                //销售组织
                if (StringUtils.isNotEmpty(importVo.getStrategyOrgErpCode())) {
                    String salesOrgCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getStrategyOrgErpCode();
                    SalesOrgVo salesOrgVo = salesOrgMap.get(salesOrgCode);
                    if (Objects.isNull(salesOrgVo)) {
                        errorList.add("销售组织[" + importVo.getStrategyOrgErpCode() + "]有误");
                    }
                    item.setStrategyOrgCode(salesOrgCode);
                    item.setStrategyOrgName(salesOrgVo.getSalesOrgName());
                }


                //活动分类
                if (StringUtils.isNotEmpty(importVo.getActivityTypeCode())) {
                    String[] codes = importVo.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityTypeName = activityTypeMap.get(code);
                        if (StringUtils.isEmpty(activityTypeName)) {
                            throw new RuntimeException("活动分类[" + code + "]有误");
                        } else {
                            allNames.add(activityTypeName);
                        }
                    }
                    item.setActivityTypeName(String.join(",", allNames));
                    item.setActivityType(item.getActivityTypeCode());
                }

                //活动形式
                if (StringUtils.isNotEmpty(importVo.getActivityFormCode())) {
                    String[] codes = importVo.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    for (String code : codes) {
                        String activityFormName = activityFormMap.get(code);
                        if (StringUtils.isEmpty(activityFormName)) {
                            throw new RuntimeException("活动形式[" + code + "]有误");
                        } else {
                            allNames.add(activityFormName);
                        }
                    }
                    item.setActivityFormName(String.join(",", allNames));
                    item.setActivityForm(item.getActivityForm());
                }

                List<MarketingStrategyBudgetDto> budgetShares = Lists.newArrayList();
                item.setBudgetShares(budgetShares);
                //月度预算
                if (StringUtils.isNotEmpty(importVo.getMonthBudgetCode())) {
                    YearBudgetVo monthBudgetVo = monthBudgetMap.get(importVo.getMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("年度预算[" + importVo.getMonthBudgetCode() + "]有误");
                    }
                    item.setMonthBudgetCode(importVo.getMonthBudgetCode());
                    item.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    item.setBudgetItemName(monthBudgetVo.getBudgetItemCode());
                    item.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());

                    MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
                    BeanUtils.copyProperties(monthBudgetVo, budgetDto);
                    budgetDto.setMonthBudgetCode(importVo.getMonthBudgetCode());
                    try {
                        budgetDto.setUseAmountStr(importVo.getFeeAmountStr());
                        budgetDto.setUseAmount(new BigDecimal(importVo.getFeeAmountStr()));
                    } catch (Exception e) {
                        throw new RuntimeException("费用格式有误!");
                    }
                    budgetShares.add(budgetDto);
                }

                //品牌
                if (StringUtils.isNotEmpty(importVo.getProductBrandCode())) {
                    String brandName = productBrandMap.get(importVo.getProductBrandCode());
                    if (StringUtils.isEmpty(brandName)) {
                        throw new RuntimeException("品牌[" + importVo.getProductBrandCode() + "]有误");
                    }
                    item.setProductBrandName(brandName);
                }


                //品类
                if (StringUtils.isNotEmpty(importVo.getProductCategoryCode())) {
                    String productLevelName = productCategoryMap.get(importVo.getProductCategoryCode());
                    if (StringUtils.isEmpty(productLevelName)) {
                        errorList.add("品类[" + importVo.getProductCategoryCode() + "]有误");
                    }
                    item.setProductCategoryName(productLevelName);
                }

                //品项
                if (StringUtils.isNotEmpty(importVo.getProductItemCode())) {
                    String productLevelName = productItemMap.get(importVo.getProductItemCode());
                    if (StringUtils.isEmpty(productLevelName)) {
                        errorList.add("品项[" + importVo.getProductItemCode() + "]有误");
                    }
                    item.setProductItemName(productLevelName);
                }

                //产品
                if (StringUtils.isNotEmpty(importVo.getProductCode())) {
                    ProductVo productVo = productMap.get(importVo.getProductCode());
                    if (null == productVo) {
                        errorList.add("产品编码[" + importVo.getProductCode() + "]有误");
                    } else {
                        item.setProductName(productVo.getProductName());
                    }
                }

                String systemName = importVo.getSystemName();
                if (StringUtils.isNotEmpty(systemName)){
                    systemName = systemName.replace("，", ",");
                    String[] form = systemName.split(",");
                    List<String> customerRetailerCodeList = new ArrayList<>();
                    for (String s : form) {
                        String code = systemMap.get(s);
                        if(StringUtils.isEmpty(code)){
                            errorList.add("零售商编码[" + s + "]有误");
                        }
                        customerRetailerCodeList.add(code);
                    }
                    String customerRetailerCode = null;
                    if (!CollectionUtils.isEmpty(customerRetailerCodeList)) {
                        customerRetailerCode = String.join(",", customerRetailerCodeList);
                    }else {
                        errorList.add("零售商名称[" + importVo.getSystemName() + "]有误");
                    }
                    item.setSystemCode(customerRetailerCode);
                }

                item.setId(UUID.randomUUID().toString().replace("-", ""));
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());

//              费效比（费效比=费用投入/销量目标）
//              销量目标   salesGoalAmount
//              费效比      costEffectivenessRatio
                BigDecimal costEffectivenessRatio = BigDecimal.ZERO;
                BigDecimal feeAmount = BigDecimal.ZERO;
                if (StringUtils.isNotEmpty(item.getFeeAmountStr())){
                    feeAmount = new BigDecimal(item.getFeeAmountStr());
                }
                if (null != item.getSalesGoalAmount() && BigDecimal.ZERO.compareTo(item.getSalesGoalAmount()) != 0) {
                    costEffectivenessRatio = feeAmount.divide(item.getSalesGoalAmount(), 4, RoundingMode.HALF_UP);
                }
                item.setCostEffectivenessRatio(costEffectivenessRatio);

                dtos.add(item);
            }

            if (errorListMap.size() > 0) {
                for (Map.Entry<Integer, List<String>> entry : errorListMap.entrySet()) {
                    List<String> value = entry.getValue();
                    if (value.size() > 0) {
                        errorMap.put(entry.getKey(), String.join(" | ", value));
                    }
                }
            }

            if (errorMap.size() == 0 && !CollectionUtils.isEmpty(dtos)) {
                marketingStrategyItemService.saveListCache(cacheKey, dtos);
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty(e.getMessage())) {
                errorMsg = "数据处理失败！";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;

    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, String desc) {
        if (StringUtils.isEmpty(dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty(dictCode)) {
            throw new RuntimeException(desc + "[" + dictValue + "]有误");
        }
        setMethod.accept(dictCode);
    }


    @Override
    public Class<MarketingStrategyDy00000010ItemImportVo> findCrmExcelVoClass() {
        return MarketingStrategyDy00000010ItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_DY00000010_ITEM_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-垂直营销策略明细导入";
    }

}
