package com.biz.crm.tpm.business.marketing.strategy.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.local.imports.vo.MarketingStrategyItemImportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 营销策略导入服务-通用
 * @author wanghaojia
 * @date 2022/11/11 16:19
 */
@Slf4j
@Component
public class MarketingStrategyImportsProcess implements ImportProcess<MarketingStrategyItemImportVo> {

    @Autowired
    private MarketingStrategyService marketingStrategyService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, MarketingStrategyItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List<MarketingStrategyItemImportVo> importVos = Lists.newArrayList(data.values());
        List<MarketingStrategyItemDto> dtos = (List<MarketingStrategyItemDto>) nebulaToolkitService.copyCollectionByWhiteList(importVos, MarketingStrategyItemImportVo.class, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class);
        marketingStrategyService.saveMutiMarketingStrategy(new MarketingStrategyDto(),dtos);
        return null;
    }

    @Override
    public Class<MarketingStrategyItemImportVo> findCrmExcelVoClass() {
        return MarketingStrategyItemImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT_COMMON";
    }

    @Override
    public String getTemplateName() {
        return "TPM-营销策略导入-通用";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MARKETING_STRATEGY_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-营销策略导入";
    }

}
