package com.biz.crm.tpm.business.marketing.strategy.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author wanghaojia
 * @date 2023/12/26 00:06
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel("营销策略明细导入VO")
public class MarketingStrategyDy00000010ItemImportVo extends CrmExcelVo {

    /**
     * 策略年月
     */
    @ApiModelProperty("策略年月")
    @CrmExcelColumn(value = "策略年月")
    private String strategyYearMonth;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "活动分类名称")
    private String activityTypeName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "活动分类编码")
    private String activityTypeCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "活动形式编码")
    private String activityFormCode;

    /**
     * 费用类型
     */
    @ApiModelProperty("费用类型")
    @CrmExcelColumn(value = "费用类型")
    private String feeType;

    /**
     * 分销渠道编码
     */
    @ApiModelProperty("分销渠道编码")
    @CrmExcelColumn(value = "分销渠道编码")
    private String distributionChannelCode;

    /**
     * 销售机构ERP编码
     */
    @ApiModelProperty("销售机构编码")
    @CrmExcelColumn(value = "销售机构编码")
    private String strategyOrgErpCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @CrmExcelColumn(value = "销售机构名称")
    private String strategyOrgName;

    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;

    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @CrmExcelColumn(value = "区域名称")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn(value = "品牌名称")
    private String productBrandName;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @CrmExcelColumn(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @CrmExcelColumn(value = "品项名称")
    private String productItemName;

    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @CrmExcelColumn(value = "品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @CrmExcelColumn(value = "品类名称")
    private String productCategoryName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    /**
     * 销量目标
     */
    @ApiModelProperty("销量目标")
    @CrmExcelColumn(value = "销量目标")
    private String salesGoalAmountStr;

    /**
     * 关联年度预算编码
     */
    @ApiModelProperty("关联年度预算编码")
    @CrmExcelColumn(value = "关联年度预算编码")
    private String monthBudgetCode;

    /**
     * 使用金额
     */
    @ApiModelProperty("使用金额")
    @CrmExcelColumn(value = "使用金额")
    private String feeAmountStr;

    /**
     * 策略明细
     */
    @ApiModelProperty("策略明细")
    @CrmExcelColumn(value = "策略明细")
    private String activityInputDirection;


}
