package com.biz.crm.tpm.business.marketing.strategy.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 营销策略导入VO
 * @author wanghaojia
 * @date 2022/11/11 16:20
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("营销策略导入VO")
public class MarketingStrategyItemDY00000008ImportVo extends CrmExcelVo {
    /**
     * 策略标识
     */
    @CrmExcelColumn(value = "* 策略标识")
    private String strategySignStr;
    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @CrmExcelColumn(value = "* 业态")
    private String businessFormatCode;
    /**
     * 业态
     */
    @ApiModelProperty("业务单元")
    @CrmExcelColumn(value = "* 业务单元")
    private String businessUnitCode;
    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型")
    @CrmExcelColumn(value = "* 策略类型")
    private String strategyType;
    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    @CrmExcelColumn(value = "* 策略名称")
    private String strategyName;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    @CrmExcelColumn(value = "* 归属部门编码")
    private String attrOrgCode;
    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    @CrmExcelColumn(value = "归属部门名称")
    private String attrOrgName;

    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    @CrmExcelColumn(value = "* 策略主题")
    private String strategyTitle;
    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    @CrmExcelColumn(value = "策略描述")
    private String strategyDesc;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "活动分类名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    @CrmExcelColumn(value = "* 一级渠道编码")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级渠道编码")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级管理渠道")
    private String secondChannelName;


    /**
     * 系统/零售商编码
     */
    @ApiModelProperty("系统/零售商编码")
    @CrmExcelColumn(value = "零售商编码")
    private String systemCode;
    /**
     * 系统/零售商名称
     */
    @ApiModelProperty("系统/零售商名称")
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn(value = "* 品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn(value = "品牌")
    private String productBrandName;
    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    @CrmExcelColumn(value = "活动力度")
    private String activityIntensity;
    /**
     * 活动场次
     */
    @CrmExcelColumn(value = "活动场次")
    private String activityNumberStr;
    /**
     * 数量
     */
    @CrmExcelColumn(value = "数量")
    private String quantityStr;

    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    @CrmExcelColumn(value = "预算编码")
    private String monthBudgetCode;
    /**
     * 预算名称
     */
    @ApiModelProperty("预算项目名称")
    @CrmExcelColumn(value = "预算项目名称")
    private String budgetItemName;
    /**
     * 归口
     */
    @ApiModelProperty("归口")
    @CrmExcelColumn(value = "费用归口")
    private String feeBelongCode;
    /**
     * 策略年月
     */
    @ApiModelProperty("预算年月")
    @CrmExcelColumn(value = "预算年月")
    private String strategyYearMonth;
    /**
     * 费用金额（元）
     */
    @CrmExcelColumn(value = "* 费用金额（元）")
    private String feeAmountStr;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @CrmExcelColumn(value = "* 区域编码")
    private String strategyOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @CrmExcelColumn(value = "区域名称")
    private String strategyOrgName;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn(value = "*销售机构编码")
    private String salesInstitutionCode;
    /**
     * 销售机构名称
     */
    @CrmExcelColumn(value = "销售机构名称")
    private String salesInstitutionName;
    /**
     * 渠道编码
     */
    @CrmExcelColumn(value = "*渠道编码")
    private String channelCode;
    /**
     * 渠道名称
     */
    @CrmExcelColumn(value = "渠道名称")
    private String channelName;

    /**
     * 策略年月
     */
    @ApiModelProperty("是否跨月策略")
    @CrmExcelColumn(value = "是否跨月策略")
    private String isCrossMonth;
    /**
     * 策略年月
     */
    @ApiModelProperty("策略开始时间")
    @CrmExcelColumn(value = "策略开始时间")
    private String beginDateStr;
    /**
     * 策略年月
     */
    @ApiModelProperty("策略结束时间")
    @CrmExcelColumn(value = "策略结束时间")
    private String endDateStr;

}
