package com.biz.crm.tpm.business.marketing.strategy.local.imports.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 营销策略导入VO
 * @author wanghaojia
 * @date 2022/11/11 16:20
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("营销策略导入VO")
public class MarketingStrategyItemDY00000010ImportVo extends CrmExcelVo {
    /**
     * 策略标识
     */
    @CrmExcelColumn(value = "* 策略标识")
    private String strategySignStr;
    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @CrmExcelColumn(value = "* 业态")
    private String businessFormatCode;
    /**
     * 业态
     */
    @ApiModelProperty("业务单元")
    @CrmExcelColumn(value = "* 业务单元")
    private String businessUnitCode;
    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型")
    @CrmExcelColumn(value = "* 策略类型")
    private String strategyType;
    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    @CrmExcelColumn(value = "* 策略名称")
    private String strategyName;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    @CrmExcelColumn(value = "* 归属部门编码")
    private String attrOrgCode;
    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    @CrmExcelColumn(value = "归属部门名称")
    private String attrOrgName;


    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    @CrmExcelColumn(value = "* 策略主题")
    private String strategyTitle;
    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    @CrmExcelColumn(value = "策略描述")
    private String strategyDesc;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn(value = "* 活动分类编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn(value = "活动分类名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn(value = "* 活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    @CrmExcelColumn(value = "一级渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @CrmExcelColumn(value = "二级管理渠道")
    private String secondChannelName;

    /**
     * 系统/零售商编码
     */
    @ApiModelProperty("系统/零售商编码")
    @CrmExcelColumn(value = "零售商编码")
    private String systemCode;
    /**
     * 系统/零售商名称
     */
    @ApiModelProperty("系统/零售商名称")
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;

    /**
     * 垂直用的区域
     */
    @CrmExcelColumn(value = "区域")
    private String region;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @CrmExcelColumn(value = "* 品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @CrmExcelColumn(value = "品牌")
    private String productBrandName;
    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    @CrmExcelColumn(value = "活动力度")
    private String activityIntensity;
    /**
     * 活动场次
     */
    @CrmExcelColumn(value = "活动场次")
    private String activityNumberStr;
    /**
     * 数量
     */
    @CrmExcelColumn(value = "数量")
    private String quantityStr;

    /**
     * 费用金额（元）
     */
    @CrmExcelColumn(value = "* 费用金额（元）")
    private String feeAmountStr;

    //* 费用金额（元）	总部费用预算编码	公投费用预算编码	自投费用预算编码	总部费用	公投费用	自投费用	策略年月
    /**
     * 总部费用预算编码
     */
    @ApiModelProperty("总部费用预算编码")
    @CrmExcelColumn(value = "总部费用预算编码")
    private String headMonthBudgetCode;

    /**
     * 公投费用预算编码
     */
    @CrmExcelColumn(value = "公投费用预算编码")
    private String regionReferendumMonthBudgetCode;

    /**
     * 自投费用预算编码
     */
    @CrmExcelColumn(value = "自投费用预算编码")
    private String regionAutomaticMonthBudgetCode;


    /**
     * 总部承担金额
     */
    @CrmExcelColumn(value = "总部费用")
    private String headFeeAmountStr;

    /**
     * 公投费用
     */
    @CrmExcelColumn("公投费用")
    private String regionReferendumFeeAmountStr;

    /**
     * 自投费用
     */
    @CrmExcelColumn("自投费用")
    private String regionAutomaticFeeAmountStr;

    /**
     * 策略年月
     */
    @ApiModelProperty("策略年月")
    @CrmExcelColumn(value = "策略年月")
    private String strategyYearMonth;

}
