package com.biz.crm.tpm.business.marketing.strategy.local.listener;

import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 营销策略审批通过回调
 * @author wanghaojia
 * @date 2022/11/30 20:57
 */
@Component
public class MarketingStrategyProcessCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private MarketingStrategyService marketingStrategyService;

    @Override
    public String getBusinessCode() {
        return MarketingStrategyConstant.PROCESS_NAME_MARKETING_STRATEGY;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessNo())){
            return;
        }
        //多策略提交
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            marketingStrategyService.processPass(dto);
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            marketingStrategyService.processRejectAndRecover(dto);
        }
    }
}
