package com.biz.crm.tpm.business.marketing.strategy.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 营销策略预算
 * @author wanghaojia
 * @date 2023/1/16 15:54
 */
public interface MarketingStrategyBudgetMapper extends BaseMapper<MarketingStrategyBudget> {


    /**
     * 根据策略编码查询预算信息
     */
    List<MarketingStrategyBudgetDto> listDtoList(@Param("itemDto") MarketingStrategyItemDto itemDto);

    List<MarketingStrategyBudgetDto> findListByConditions(@Param("dto") MarketingStrategyBudgetDto dto);

    List<MarketingStrategyBudgetDto> listBudgetInfoByOperateList(@Param("operateCodeList") List<String> operateCodeList);

    /**
     * 分页查询策略上的预算信息
     * @param page 分页参数
     * @param dto 查询属性
     */
    Page<MarketingStrategyBudgetVo> findConditions(@Param("page") Page<MarketingStrategyBudgetVo> page, @Param("dto") MarketingStrategyBudgetDto dto);

    void updateStrategyUsedAmount(@Param("strategyCodeList") List<String> strategyCodeList);

    void updateHeadStatus(@Param("strategyItemCodeList") List<String> strategyItemCodeList);

}
