package com.biz.crm.tpm.business.marketing.strategy.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 营销策略(MarketingStrategy)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:22
 */
public interface MarketingStrategyItemMapper extends BaseMapper<MarketingStrategyItem> {

    /**
     * 筛选条件分页查询
     * @param page 分页参数
     * @param dto 查询对象
     * @return 分页数据
     */
    Page<MarketingStrategyItemVo> findByConditions(@Param("page") Page<MarketingStrategyItemVo> page, @Param("dto") MarketingStrategyItemDto dto);

    /**
     * 更据编码获取
     *
     * @param itemCodes
     * @return
     */
    List<MarketingStrategyItemVo> findByCodes(@Param("itemCodes") List<String> itemCodes);
    /**
     * 主列表明细导出获取总条数
     *
     * @param dto
     * @return
     */
    Integer itemExportGetTotal(@Param("dto") MarketingStrategyItemDto dto);

    /**
     * 主列表明细导出获取数据
     *
     * @param page
     * @param dto
     * @return
     */
    Page<MarketStrategyItemExportVo> itemExportGetDate(Page<MarketStrategyItemExportVo> page, @Param("dto") MarketingStrategyItemDto dto);
}

