package com.biz.crm.tpm.business.marketing.strategy.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 营销策略(MarketingStrategy)表mybatis访问层
 *
 * @author wanghaojia
 * @since 2022-11-05 16:06:03
 */
public interface MarketingStrategyMapper extends BaseMapper<MarketingStrategy> {

    /**
     * 分页查询所有数据
     *
     * @param page              分页对象
     * @param marketingStrategy 查询实体
     * @return 所有数据
     */
    public Page<MarketingStrategyVo> findByConditions(@Param("page") Page<MarketingStrategyVo> page, @Param("dto") MarketingStrategyDto marketingStrategy);

    void updateFeeAmount(@Param("strategyCodeList") List<String> strategyCodeList);

}

