package com.biz.crm.tpm.business.marketing.strategy.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyItemModifyService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyModifyFieldValue;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyToModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 营销策略明细变更接口
 * @author wanghaojia
 * @date 2022/12/26 10:59
 */
@RestController
@RequestMapping("/v1/marketingStrategyItemModify")
@Slf4j
@Api(tags = "营销策略明细变更接口")
public class MarketingStrategyItemModifyController extends MnPageCacheController<MarketingStrategyItemModifyVo, MarketingStrategyItemModifyDto> {

    /**
     * 营销策略变更明细服务
     */
    @Autowired(required = false)
    private MarketingStrategyItemModifyService marketingStrategyItemModifyService;

    /**
     * 获取待调整的营销策略明细数据
     * @return
     */
    @ApiOperation(value = "获取待调整的营销策略明细数据")
    @PostMapping(value = "initToModifyList")
    public Result<Page<MarketingStrategyItemModifyVo>> initToModifyList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                        @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey,
                                                                        @ApiParam(value = "查询条件") @RequestBody MarketingStrategyToModifyDto dto){
        //调整维度：基本信息（策略名称、策略主题、策略描述）、范围（区域、一级管理渠道、二级管理渠道、系统、品牌）、活动类型、活动形式、力度（活动力度、活动场次、数量）、费用金额
        //基本信息、范围调整、活动类型、活动形式、力度调整，与新增逻辑一致。
        //费用金额调整：1）只能调整该年度预算当月滚动后的预算或未规划完的预算。（跨月的调整就需要涉及预算之间的调整了）
        //2）一条预算规划到不同区域，可在不同区域之间调整金额
        //调整限制：1）历史策略不能调整；2）已关联方案的策略不能调整
        try {
            this.marketingStrategyItemModifyService.initToModifyList(cacheKey,dto);
            Page<MarketingStrategyItemModifyVo> page = this.marketingStrategyItemModifyService.findCachePageList(pageable, null, cacheKey);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "获取预算汇总信息")
    @PostMapping("findBudgetCacheSumList")
    public Result<List<MarketingStrategyBudgetSumVo>> findBudgetCacheSumList(@ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            List<MarketingStrategyBudgetSumVo> list = this.marketingStrategyItemModifyService.findBudgetCacheSumList(cacheKey);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /*===============================================================明细列表缓存分页End============================================================*/

    /**
     * 分页查询明细所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询明细行所有数据")
    @GetMapping("findItemByConditions")
    public Result<Page<MarketingStrategyItemModifyVo>> findItemByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "dto", value = "查询实体") MarketingStrategyItemModifyDto dto) {
        try {
            Validate.notBlank(dto.getModifyBusinessCode(),"策略变更编码不能为空！");
            Page<MarketingStrategyItemModifyVo> page =  this.marketingStrategyItemModifyService.findByConditions(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findItemBeforeModifyList")
    public Result<Page<MarketingStrategyItemModifyVo>> findItemBeforeModifyList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                          @ApiParam(name = "dto", value = "查询实体") MarketingStrategyItemModifyDto dto){
        try {
            Validate.notBlank(dto.getModifyBusinessCode(),"策略变更编码不能为空！");
            Page<MarketingStrategyItemModifyVo> page = this.marketingStrategyItemModifyService.findItemBeforeModifyList(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findItemModifyLFieldValueList")
    public Result<Page<MarketingStrategyModifyFieldValue>> findItemModifyLFieldValueList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                    @ApiParam(name = "dto", value = "查询实体") MarketingStrategyItemModifyDto dto){
        try {
            Validate.notBlank(dto.getModifyBusinessCode(),"策略变更编码不能为空！");
            Page<MarketingStrategyModifyFieldValue> page = this.marketingStrategyItemModifyService.findItemModifyLFieldValueList(pageable,dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findItemModifyLFieldValueListByProcessNo")
    public Result<List<MarketingStrategyModifyFieldValue>> findItemModifyLFieldValueListByProcessNo(@ApiParam(value = "流程编号")@RequestParam String processNo){
        try {
            List<MarketingStrategyModifyFieldValue> list = this.marketingStrategyItemModifyService.findItemModifyLFieldValueListByProcessNo(processNo);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略调整前数据查询
     */
    @ApiOperation(value = "策略调整前数据查询")
    @PostMapping(value = "findAdjustBudgetListByModifyCode")
    public Result<List<MarketingStrategyModifyAdjustBudgetVo>> findAdjustBudgetListByModifyCode(@ApiParam(name = "dto", value = "查询实体") MarketingStrategyModifyAdjustBudgetDto dto){
        try {
            List<MarketingStrategyModifyAdjustBudgetVo> list = Lists.newArrayList();
            if (StringUtils.isNotEmpty(dto.getModifyBusinessCode())){
                list = this.marketingStrategyItemModifyService.findAdjustBudgetVoListByModifyCode(dto.getModifyBusinessCode());
            }else if (StringUtils.isNotEmpty(dto.getProcessNo())){
                list = this.marketingStrategyItemModifyService.findAdjustBudgetVoListByProcessNo(dto.getProcessNo());
            }else{
                throw new RuntimeException("参数有误！");
            }
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 执行变更
     */
    @ApiOperation(value = "执行变更")
    @PostMapping("/doUpdatePlanData")
    public Result doUpdatePlanData(@RequestParam String modifyCode) {
        try {
            this.marketingStrategyItemModifyService.doUpdatePlanData(modifyCode);
            return Result.ok("提交成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
