package com.biz.crm.tpm.business.marketing.strategy.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 营销策略变更接口
 * @author wanghaojia
 * @date 2022/12/3 10:25
 */
@RestController
@RequestMapping("/v1/marketingStrategyModify")
@Slf4j
@Api(tags = "营销策略变更接口")
public class MarketingStrategyModifyController {

    /**
     * 营销策略变更服务
     */
    @Autowired(required = false)
    private MarketingStrategyModifyService marketingStrategyModifyService;
    /**
     * 活动配置模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    /**
     * 策略新增保存
     * @param cacheKey 明细缓存key
     * @return
     */
    @ApiOperation(value = "策略调整新增保存")
    @PostMapping(value = "saveMarketingStrategyModify")
    public Result saveMarketingStrategyModify(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                                              @ApiParam(name = "MarketingStrategyModifyDto", value = "策略调整表头")@RequestBody MarketingStrategyModifyDto dto){
        try {
            dto.setId(null);
            this.marketingStrategyModifyService.saveMarketingStrategyModify(dto,cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略新增保存
     * @param cacheKey 明细缓存key
     * @return
     */
    @ApiOperation(value = "策略调整新增保存")
    @PatchMapping(value = "saveMarketingStrategyModify")
    public Result updateMarketingStrategyModify(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                                              @ApiParam(name = "MarketingStrategyModifyDto", value = "策略调整表头")@RequestBody MarketingStrategyModifyDto dto){
        try {
            if (StringUtils.isEmpty(dto.getId())){
                throw new RuntimeException("编辑策略参数有误");
            }
            this.marketingStrategyModifyService.saveMarketingStrategyModify(dto,cacheKey);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }



    /**
     * 获取单策略新增表头模板
     */
    @ApiOperation(value = "获取策略调整新增表头模板")
    @GetMapping("getSingleStrategyHeadConfig")
    public Result<ActivitiesTemplateConfigVo> getSingleStrategyHeadConfig() {
        return getActivitiesTemplateConfigVoResult(MarketingStrategyConstant.MODIFY_STRATEGY_COLUMN_TEMPLATE_CONFIG_CODE);
    }

    /**
     * 根据编码获取活动配置模板
     *
     * @param configCode 模板编码
     * @return 接口返回结果
     */
    private Result<ActivitiesTemplateConfigVo> getActivitiesTemplateConfigVoResult(String configCode) {
        try {
            ActivitiesTemplateConfigVo configVo = activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok(configVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过id获取营销策略数据
     */
    @ApiOperation(value = "通过id获取营销策略数据")
    @GetMapping("findById")
    public Result<MarketingStrategyModifyVo> findById(@ApiParam(value = "id")@RequestParam String id){
        try {
            MarketingStrategyModifyVo vo = this.marketingStrategyModifyService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除策略调整
     * @param ids 策略ids
     */
    @ApiOperation(value = "删除策略调整")
    @DeleteMapping(value = "delete")
    public Result delete(@ApiParam(value = "策略id集合")@RequestParam List<String> ids){
        try {
            this.marketingStrategyModifyService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 提交审批流
     *
     * @param dto 查询对象
     * @return
     */
    @ApiOperation(value = "提交审批流")
    @PostMapping("/submit")
    public Result submit(@RequestBody MarketingStrategyModifyApproveSubmitDto dto) {
        try {
            this.marketingStrategyModifyService.submit(dto);
            return Result.ok("提交成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 策略新增保存
     * @param cacheKey 明细缓存key
     * @return
     */
    @ApiOperation(value = "策略调整新增保存校验")
    @PostMapping(value = "validateMarketingStrategyModify")
    public Result<Result<List<MarketingStrategyModifyAdjustBudgetVo>>> validateMarketingStrategyModify(@ApiParam(name = "cacheKey", value = "缓存键")@RequestParam String cacheKey,
                                                  @ApiParam(name = "MarketingStrategyModifyDto", value = "策略调整表头")@RequestBody MarketingStrategyModifyDto dto){
        try {
            Result<List<MarketingStrategyModifyAdjustBudgetVo>> result = this.marketingStrategyModifyService.validateMarketingStrategyModify(dto,cacheKey);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询营销策略变更
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询营销策略变更")
    @GetMapping("findByConditions")
    public Result<Page<MarketingStrategyModifyVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
        @ApiParam(name = "MarketingStrategyModifyDto", value = "营销策略变更") MarketingStrategyModifyDto dto) {
        try {
            Page<MarketingStrategyModifyVo> page = this.marketingStrategyModifyService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
