package com.biz.crm.tpm.business.marketing.strategy.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 营销策略(MarketingStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyItemModify", description = "营销策略变更明细")
@TableName("tpm_marketing_strategy_item_modify")
@Getter
@Setter
@Entity(name = "tpm_marketing_strategy_item_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_strategy_item_modify", comment = "营销策略明细")
@Table(
    name = "tpm_marketing_strategy_item_modify",
    indexes = {
        @Index(name = "marketing_strategy_item_modify_inx1", columnList = "modify_business_code,", unique = false),
        @Index(name = "marketing_strategy_item_modify_inx2", columnList = "curr_modify_business_code,", unique = false),
        @Index(name = "marketing_strategy_item_modify_inx3", columnList = "strategy_code,", unique = false),
        @Index(name = "marketing_strategy_item_modify_inx4", columnList = "strategy_item_code,", unique = false),
        @Index(name = "marketing_strategy_item_modify_inx5", columnList = "modify_business_code,strategy_item_code", unique = true),
    }
)
public class MarketingStrategyItemModify extends TenantFlagOpEntity {

    /**
     * 策略编码
     */
    @ApiModelProperty("变更策略编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更策略编码'")
    private String modifyBusinessCode;
    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    @Column(name = "curr_modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '调整前版本号'")
    private String currModifyBusinessCode;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    @Column(name = "strategy_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略编码'")
    private String strategyCode;

    /**
     * 策略明细编码
     */
    @ApiModelProperty("策略明细编码")
    @Column(name = "strategy_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '策略明细编码'")
    private String strategyItemCode;

    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    @Column(name = "strategy_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '策略名称'")
    private String strategyName;
    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    @Column(name = "strategy_title", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '策略主题'")
    private String strategyTitle;
    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    @Column(name = "strategy_desc", nullable = true, length = 1000, columnDefinition = "varchar(1000) COMMENT '策略描述'")
    private String strategyDesc;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @Column(name = "strategy_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String strategyOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @Column(name = "strategy_org_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String strategyOrgName;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    @Column(name = "first_channel_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '一级管理渠道'")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    @Column(name = "second_channel_code", nullable = true, length = 32, columnDefinition = "varchar(512) COMMENT '二级管理渠道'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", nullable = true, length = 128, columnDefinition = "varchar(2000) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '系统'")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '系统/零售商名称'")
    private String systemName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 500, columnDefinition = "varchar(500) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 1000, columnDefinition = "varchar(4000) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 500, columnDefinition = "varchar(500) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 1000, columnDefinition = "varchar(4000) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    @Column(name = "activity_intensity", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动力度'")
    private String activityIntensity;
    /**
     * 活动场次
     */
    @ApiModelProperty("活动场次")
    @Column(name = "activity_number", nullable = true, length = 11, columnDefinition = "int(11) COMMENT '活动场次'")
    private Integer activityNumber;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", nullable = true, length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;

    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    @Column(name = "fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用金额（元）'")
    private BigDecimal feeAmount;

    /**
     * 控制系数
     */
    @ApiModelProperty(value = "控制系数")
    @Column(name = "control_ratio", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '控制系数'")
    private BigDecimal controlRatio;

    /**
     * 策略开始年月
     */
    @ApiModelProperty("策略开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "begin_date", length = 20, columnDefinition = "datetime COMMENT '策略开始时间 '")
    private Date beginDate;
    /**
     * 策略结束年月
     */
    @ApiModelProperty("策略结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", length = 20, columnDefinition = "datetime COMMENT '策略结束时间 '")
    private Date endDate;
    /**
     * 是否跨月策略
     */
    @ApiModelProperty(name = "是否跨月策略", notes = "")
    @Column(name = "is_cross_month", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否跨月策略，   Y是N否'")
    private String isCrossMonth;
}

