package com.biz.crm.tpm.business.marketing.strategy.local.modify.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.List;

/**
 * 营销策略(MarketingStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-05 15:57:30
 */
@ApiModel(value = "MarketingStrategy", description = "营销策略变更")
@TableName("tpm_marketing_strategy_modify")
@Getter
@Setter
@Entity(name = "tpm_marketing_strategy_modify")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_strategy_modify", comment = "营销策略变更")
@Table(
    name = "tpm_marketing_strategy_modify",
    indexes = {
        @Index(name = "marketing_strategy_modify_inx1", columnList = "modify_business_code,", unique = true)
    }
)
public class MarketingStrategyModify extends TenantFlagOpEntity {
    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '业务单元'")
    private String businessUnitCode;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    @Column(name = "attr_org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '归属部门编码'")
    private String attrOrgCode;

    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    @Column(name = "attr_org_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '归属部门名称'")
    private String attrOrgName;

    /**
     * 多选逗号隔开
     */
    @ApiModelProperty("策略年月（多选逗号隔开）")
    @Column(name = "strategy_year_month", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '策略年月（多选逗号隔开）'")
    private String strategyYearMonth;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码（多选逗号隔开）", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '预算项目编码（多选逗号隔开）'")
    private String budgetItemCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目名称（多选逗号隔开）", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '预算项目名称（多选逗号隔开）'")
    private String budgetItemName;

    /**
     * 调整说明
     */
    @ApiModelProperty("调整说明")
    @Column(name = "modify_explain", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '调整说明'")
    private String modifyExplain;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    @Column(name = "process_no", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    @Column(name = "strategy_code", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '策略编码'")
    private String strategyCode;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略明细编码")
    @Column(name = "strategy_item_code", nullable = true, length = 1024, columnDefinition = "varchar(1024) COMMENT '策略明细编码'")
    private String strategyItemCode;

}

