package com.biz.crm.tpm.business.marketing.strategy.local.modify.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author wanghaojia
 * @date 2023/6/1 16:41
 */
@ApiModel(value = "MarketingStrategyModifyAdjustBudget", description = "营销策略调整")
@TableName("tpm_marketing_strategy_modify_adjust_budget")
@Getter
@Setter
@Entity(name = "tpm_marketing_strategy_modify_adjust_budget")
@org.hibernate.annotations.Table(appliesTo = "tpm_marketing_strategy_modify_adjust_budget", comment = "营销策略调整")
@Table(
        name = "tpm_marketing_strategy_modify_adjust_budget",
        indexes = {
                @Index(name = "tpm_marketing_strategy_modify_adjust_budget_inx1", columnList = "modify_business_code,")
        }
)
public class MarketingStrategyModifyAdjustBudget extends TenantFlagOpEntity {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    @Column(name = "modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '变更编码'")
    private String modifyBusinessCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String monthBudgetCode;

    /**
     * 年月-调入方
     */
    @ApiModelProperty(value = "年月-调入方", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "varchar(19) COMMENT '年月-调入方'")
    private String yearMonthLy;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    @Column(name = "after_freeze_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '冻结后可用金额'")
    private BigDecimal afterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    @Column(name = "used_strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已使用策略金额 '")
    private BigDecimal usedStrategyAmount;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    @Column(name = "accumulated_available_balance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计可用余额 '")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "adjust_out_month_budget_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String adjustOutMonthBudgetCode;


    /**
     * 年月-调出方
     */
    @ApiModelProperty(value = "年月-调出方", notes = "")
    @Column(name = "adjust_out_year_month_ly", nullable = true, length = 32, columnDefinition = "varchar(19) COMMENT '年月-调出方'")
    private String adjustOutYearMonthLy;


    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "adjust_out_budget_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String adjustOutBudgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "adjust_out_budget_item_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '预算项目名称'")
    private String adjustOutBudgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "adjust_out_fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String adjustOutFeeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    @Column(name = "adjust_out_after_freeze_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '冻结后可用金额'")
    private BigDecimal adjustOutAfterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    @Column(name = "adjust_out_used_strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已使用策略金额 '")
    private BigDecimal adjustOutUsedStrategyAmount;

    /**
     * 累计可用余额（调出方）
     */
    @ApiModelProperty(value = "累计可用余额（调出方）", notes = "")
    @Column(name = "adjust_out_accumulated_available_balance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计可用余额（调出方） '")
    private BigDecimal adjustOutAccumulatedAvailableBalance;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额", notes = "")
    @Column(name = "adjust_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '调整金额 '")
    private BigDecimal adjustAmount;

    /**
     * 调出说明
     */
    @ApiModelProperty(value = "调出说明", notes = "")
    @Column(name = "adjust_remarks", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '调出说明'")
    private String adjustRemarks;

}
