package com.biz.crm.tpm.business.marketing.strategy.local.modify.listener;

import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyModifyMqConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyModifyMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 分子公司活动细案审批通过
 */
@Slf4j
@Component
public class MarketingStrategyModifyCompleteListener implements ProcessCompleteListener {

    @Autowired(required = false)
    private MarketingStrategyModifyService marketingStrategyModifyService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Override
    public String getBusinessCode() {
        return MarketingStrategyConstant.PROCESS_NAME_MARKETING_STRATEGY_MODIFY;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {

        if (StringUtils.isEmpty(dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");

        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            marketingStrategyModifyService.processPass(dto);
            passPushMq(dto.getProcessNo(),dto.getBusinessNo());
        }
        //审批驳回|流程追回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) ||
                ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            marketingStrategyModifyService.processRejectAndRecover(dto);
        }

    }

    /**
     * 审批通过推送mq处理
     * @param processNo 流程编号
     * @param businessNo 业务编码
     */
    private void passPushMq(String processNo,String businessNo){
        if (StringUtils.isEmpty(businessNo)){
            return;
        }

        List<MarketingStrategyModifyMqTagEnum> pushTagList = Lists.newArrayList();
        for (MarketingStrategyModifyMqTagEnum mqTagEnum : MarketingStrategyModifyMqTagEnum.values()) {
            if (MarketingStrategyModifyMqTagEnum.PushType.code.equals(mqTagEnum.getPushType())){
                pushTagList.add(mqTagEnum);
            }
        }

        if (CollectionUtils.isEmpty(pushTagList)){
            return;
        }

        for (MarketingStrategyModifyMqTagEnum mqTagEnum : pushTagList) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic(MarketingStrategyModifyMqConstant.PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }

}
