package com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyItemModify;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyToModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 营销策略变更明细行
 * @author wanghaojia
 * @date 2022/12/3 15:37
 */
public interface MarketingStrategyItemModifyMapper extends BaseMapper<MarketingStrategyItemModify> {

    /**
     * 查询待调整数据
     * @param dto
     * @return
     */
    List<MarketingStrategyItemModifyDto> findToModifyList(@Param("dto") MarketingStrategyToModifyDto dto);

    /**
     * 提交流中过滤
     * @param modifyBusinessCode
     * @return
     */
    List<MarketingStrategyItemModifyDto>  findListByModifyBusinessCode(@Param("modifyBusinessCode") String modifyBusinessCode);
    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    Page<MarketingStrategyItemModifyVo> findByConditions(@Param("page") Page<MarketingStrategyItemModifyVo> page, @Param("dto") MarketingStrategyItemModifyDto dto);

    /**
     * 分页查询调整前数据
     * @param dto
     * @return
     */
    Page<MarketingStrategyItemModifyVo> findItemBeforeModifyList(@Param("page") Page<MarketingStrategyItemModifyVo> page, @Param("dto") MarketingStrategyItemModifyDto dto);
}
