package com.biz.crm.tpm.business.marketing.strategy.local.modify.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 营销策略调整(MarketingStrategy)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-05 16:06:03
 */
@Component
public class MarketingStrategyModifyDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_marketing_strategy_modify_data_view";
    }

    @Override
    public String desc() {
        return "TPM-营销策略调整";
    }

    @Override
    public String buildSql() {
        return "select\n" +
                "a.*\n" +
                " from tpm_marketing_strategy_modify a\n" +
                "where a.tenant_code = :tenantCode\n" +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }

}
