package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyBudgetModifyMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 营销策略(MarketingStrategy)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-11-05 16:06:03
 */
@Component
public class MarketingStrategyBudgetModifyRepository extends ServiceImpl<MarketingStrategyBudgetModifyMapper, MarketingStrategyBudgetModify> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<MarketingStrategyBudgetVo> voList) {
        if (CollectionUtils.isEmpty(voList)){
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        for (MarketingStrategyBudgetVo item : voList) {
            this.fillVoProperties(item,propertyMap);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(MarketingStrategyBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        this.fillVoProperties(item,propertyMap);
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(MarketingStrategyBudgetVo item,Map<String, PropertyDescriptor> propertyMap) {
        if (null == item){
            return;
        }
        //统一做BigDecimal,integer,Date类型格式转换
        ObjectConvertStringUtil.fillObjectStrProperties(item, MarketingStrategyBudgetVo.class,propertyMap);
        BigDecimal useAmount = Optional.ofNullable(item.getUseAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(useAmount.subtract(usedAmount));
    }

    /**
     * 根据测量编码查询所有关联预算
     * @param modifyBusinessCode 变更编码
     */
    public List<MarketingStrategyBudgetModifyDto> findDtoListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank(modifyBusinessCode)){
            return Lists.newArrayList();
        }
        LambdaQueryWrapper<MarketingStrategyBudgetModify> wrapper = Wrappers.lambdaQuery(MarketingStrategyBudgetModify.class)
                .eq(MarketingStrategyBudgetModify::getModifyBusinessCode,modifyBusinessCode)
                .eq(MarketingStrategyBudgetModify::getTenantCode, TenantUtils.getTenantCode())
                .eq(MarketingStrategyBudgetModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        List<MarketingStrategyBudgetModify> list = this.list(wrapper);
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        List<MarketingStrategyBudgetModifyDto> dtoList = (List<MarketingStrategyBudgetModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyBudgetModify.class, MarketingStrategyBudgetModifyDto.class, HashSet.class, ArrayList.class);
        return dtoList;
    }

    /**
     * 根据细案编码查询
     **/
    public List<MarketingStrategyBudgetModifyDto> listByStrategyItem(MarketingStrategyItemModifyDto dto) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(dto.getModifyBusinessCode())) {
            return null;
        }
        return baseMapper.listDtoList(dto);
    }

    /**
     * 根据细案编码查询
     **/
    public List<MarketingStrategyBudgetModifyDto> listByModifyBusinessCode(String modifyBusinessCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(modifyBusinessCode)) {
            return null;
        }
        MarketingStrategyItemModifyDto itemDto = new MarketingStrategyItemModifyDto();
        itemDto.setModifyBusinessCode(modifyBusinessCode);
        return listByStrategyItem(itemDto);
    }

    /**
     * 根据细案编码查询
     **/
    public List<MarketingStrategyBudgetModify> listByModifyBusinessCodeList(List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(MarketingStrategyBudgetModify::getModifyBusinessCode, modifyBusinessCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<MarketingStrategyBudgetModify> updateWrapper = new UpdateWrapper<MarketingStrategyBudgetModify>().lambda();
        updateWrapper.set(MarketingStrategyBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyBudgetModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)){
            return;
        }
        LambdaUpdateWrapper<MarketingStrategyBudgetModify> updateWrapper = new UpdateWrapper<MarketingStrategyBudgetModify>().lambda();
//        updateWrapper.set(MarketingStrategyBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyBudgetModify::getModifyBusinessCode, modifyBusinessCodeList);
        updateWrapper.eq(MarketingStrategyBudgetModify::getTenantCode, TenantUtils.getTenantCode());
        this.remove(updateWrapper);
    }

}

