package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyItemModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyItemModifyMapper;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyToModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

;

/**
 * 营销策略变更
 * @author wanghaojia
 * @date 2022/12/3 15:36
 */
@Component
public class MarketingStrategyItemModifyRepository extends ServiceImpl<MarketingStrategyItemModifyMapper, MarketingStrategyItemModify> {

    @Autowired(required = false)
    private MarketingStrategyItemModifyMapper marketingStrategyItemModifyMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;

    @Autowired(required = false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 查询可以调整的营销策略明细
     * @param dto
     * @return
     */
    public List<MarketingStrategyItemModifyDto> findToModifyList(MarketingStrategyToModifyDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<MarketingStrategyItemModifyDto> toModifyList = marketingStrategyItemModifyMapper.findToModifyList(dto);
        //重置下id，不然保存的时候数据会重复
        for (MarketingStrategyItemModifyDto marketingStrategyItemModifyDto : toModifyList) {
            marketingStrategyItemModifyDto.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        this.fillDtoListProperties(toModifyList);
        return toModifyList;
    }

    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyItemModifyDto> findDtoListByModifyCode(String strategyCode){
        if (StringUtils.isBlank(strategyCode)){
            return null;
        }
        List<MarketingStrategyItemModify> list = findListByModifyCode(strategyCode);
        List<MarketingStrategyItemModifyDto> dtoList = (List<MarketingStrategyItemModifyDto>) nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyItemModify.class, MarketingStrategyItemModifyDto.class, HashSet.class, ArrayList.class);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyItemModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return null;
        }

        MarketingStrategyItemModifyDto dto = new MarketingStrategyItemModifyDto();
        dto.setModifyBusinessCode(modifyCode);
        return findList(dto);
    }
    public List<MarketingStrategyItemModifyDto> findListByModifyBusinessCode(String modifyBusinessCode){
        if (StringUtils.isBlank(modifyBusinessCode)){
            return null;
        }
        return this.marketingStrategyItemModifyMapper.findListByModifyBusinessCode(modifyBusinessCode);
    }

    /**
     * 根据查询条件筛选集合
     * @param dto 查询参数
     */
    public List<MarketingStrategyItemModify> findList(MarketingStrategyItemModifyDto dto) {
        LambdaQueryWrapper<MarketingStrategyItemModify> wrapper = Wrappers.lambdaQuery(MarketingStrategyItemModify.class)
                .eq(StringUtils.isNotBlank(dto.getModifyBusinessCode()), MarketingStrategyItemModify::getModifyBusinessCode, dto.getModifyBusinessCode())
                .eq(MarketingStrategyItemModify::getTenantCode, TenantUtils.getTenantCode())
                .eq(MarketingStrategyItemModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        return this.list(wrapper);
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<MarketingStrategyItemModify> updateWrapper = new UpdateWrapper<MarketingStrategyItemModify>().lambda();
        updateWrapper.set(MarketingStrategyItemModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyItemModify::getId, ids);
        updateWrapper.eq(MarketingStrategyItemModify::getTenantCode, TenantUtils.getTenantCode());
        this.remove(updateWrapper);
    }

    /**
     * 通过策略变更编码删除明细数据
     * @param modifyCodes 策略变更编码
     */
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        LambdaUpdateWrapper<MarketingStrategyItemModify> updateWrapper = new UpdateWrapper<MarketingStrategyItemModify>().lambda();
        updateWrapper.set(MarketingStrategyItemModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyItemModify::getModifyBusinessCode, modifyCodes);
        updateWrapper.eq(MarketingStrategyItemModify::getTenantCode, TenantUtils.getTenantCode());
        this.update(updateWrapper);
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    public Page<MarketingStrategyItemModifyVo> findByConditions(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        Page<MarketingStrategyItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyItemModifyVo> pageList = this.marketingStrategyItemModifyMapper.findByConditions(page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    /**
     * 分页查询调整前数据
     * @param dto
     * @return
     */
    public Page<MarketingStrategyItemModifyVo> findItemBeforeModifyList(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        Page<MarketingStrategyItemModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<MarketingStrategyItemModifyVo> pageList = this.marketingStrategyItemModifyMapper.findItemBeforeModifyList(page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public List<MarketingStrategyItemModifyDto> findDtoAndAttachList(MarketingStrategyItemModifyDto dto) {
        List<MarketingStrategyItemModifyDto> dtoList = this.findDtoListByModifyCode(dto.getModifyBusinessCode());
        if (CollectionUtils.isEmpty(dtoList)){
            return Lists.newArrayList();
        }
        
        //营销策略就附带一个预算
        List<MarketingStrategyBudgetModifyDto> budgetList = marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(dto.getModifyBusinessCode());
        if (!CollectionUtils.isEmpty(budgetList)){
            convertMonthBudgetProperty(budgetList);
            for (MarketingStrategyBudgetModifyDto budgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull(budgetDto.getUseAmount(), budgetDto::setUseAmountStr);
                BigDecimal afterFreezeAmount = Optional.ofNullable(budgetDto.getAfterFreezeAmount()).orElse(BigDecimal.ZERO);
                BigDecimal usedStrategyAmount = Optional.ofNullable(budgetDto.getUsedStrategyAmount()).orElse(BigDecimal.ZERO);
                BigDecimal usableStrategyAmount = afterFreezeAmount.subtract(usedStrategyAmount);
                budgetDto.setUsableStrategyAmount(usableStrategyAmount);
            }
            Map<String, List<MarketingStrategyBudgetModifyDto>> budgetMap = budgetList.stream().filter(item -> com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank(item.getStrategyItemCode())).collect(Collectors.groupingBy(MarketingStrategyBudgetModifyDto::getStrategyItemCode));
            for (MarketingStrategyItemModifyDto marketingStrategyItemDto : dtoList) {
                if (budgetMap.containsKey(marketingStrategyItemDto.getStrategyItemCode())){
                    marketingStrategyItemDto.setBudgetShares(budgetMap.get(marketingStrategyItemDto.getStrategyItemCode()));
                }
            }
        }
        return dtoList;
    }


    /**
     * 转换字段
     */
    public void convertMonthBudgetProperty(List<MarketingStrategyBudgetModifyDto> list){
        if (CollectionUtils.isEmpty(list)){
            return;
        }
        Map<String,String> feeSourceMap = Maps.newHashMap();
        if (null != dictDataVoService){
            try {
                List<DictDataVo> feeSourceList = dictDataVoService.findByDictTypeCode(MonthBudgetConstant.DICT_TPM_FEE_BELONG_US);
                if (!CollectionUtils.isEmpty(feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            } catch (Exception e) {
                log.error("费用归口数据字典查询失败：" + e.getMessage());
            }
        }
        for (MarketingStrategyBudgetModifyDto vo : list) {
            //费用来源转换
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getFeeBelongCode())){
                vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(),vo.getFeeBelongCode()));
            }
        }
    }


    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoListProperties(List<MarketingStrategyItemModifyVo> voList) {
        if (CollectionUtils.isEmpty(voList)){
            return;
        }
        List<String> strategyItemCodeList = voList.stream().map(MarketingStrategyItemModifyVo::getStrategyItemCode).collect(Collectors.toList());

        //有策略编码，从数据库里面查出来放到缓存里面
        MarketingStrategyItemDto itemSearchDto = new MarketingStrategyItemDto();
        itemSearchDto.setStrategyItemCodeList(strategyItemCodeList);
        List<MarketingStrategyItemDto> itemDtoList = marketingStrategyItemRepository.findDtoAndAttachList(itemSearchDto);
        Map<String, MarketingStrategyItemDto> originMap = itemDtoList.stream().collect(Collectors.toMap(MarketingStrategyItemDto::getStrategyItemCode, Function.identity(), (o, n) -> n));

        for (MarketingStrategyItemModifyVo modifyItemDto : voList) {
            MarketingStrategyItemModify modifyItem = nebulaToolkitService.copyObjectByWhiteList(modifyItemDto, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class);
            MarketingStrategyItemDto originItem = originMap.get(modifyItem.getStrategyItemCode());
            BeanUtils.copyProperties(originItem,modifyItemDto);
            BeanUtils.copyProperties(modifyItem,modifyItemDto);
        }

        for (MarketingStrategyItemModifyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillVoProperties(MarketingStrategyItemModifyVo item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,MarketingStrategyItemModifyVo.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoListProperties(List<? extends MarketingStrategyItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }

        List<String> strategyItemCodeList = dtoList.stream().map(MarketingStrategyItemModifyDto::getStrategyItemCode).collect(Collectors.toList());

        //有策略编码，从数据库里面查出来放到缓存里面
        MarketingStrategyItemDto itemSearchDto = new MarketingStrategyItemDto();
        itemSearchDto.setStrategyItemCodeList(strategyItemCodeList);
        List<MarketingStrategyItemDto> itemDtoList = marketingStrategyItemRepository.findDtoAndAttachList(itemSearchDto);
        Map<String, MarketingStrategyItemDto> originMap = itemDtoList.stream().collect(Collectors.toMap(MarketingStrategyItemDto::getStrategyItemCode, Function.identity(), (o, n) -> n));

        for (MarketingStrategyItemModifyDto modifyItemDto : dtoList) {
            String attrOrgCode = modifyItemDto.getAttrOrgCode();
            String attrOrgName = modifyItemDto.getAttrOrgName();

            MarketingStrategyItemModify modifyItem = nebulaToolkitService.copyObjectByWhiteList(modifyItemDto, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class);
            MarketingStrategyItemDto originItem = originMap.get(modifyItem.getStrategyItemCode());
            BeanUtils.copyProperties(originItem,modifyItemDto);
            BeanUtils.copyProperties(modifyItem,modifyItemDto);

            modifyItemDto.setAttrOrgCode(attrOrgCode);
            modifyItemDto.setAttrOrgName(attrOrgName);
        }

        for (MarketingStrategyItemModifyDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    /**
     * 设置VO里面的几个str属性，前端用此字段，避免出现格式问题
     */
    public void fillDtoProperties(MarketingStrategyItemModifyDto item) {
        if (null == item){
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties(item,MarketingStrategyItemModifyDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }
}
