package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModifyAdjustBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyModifyAdjustBudgetMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

;import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 营销策略变更
 * @author wanghaojia
 * @date 2022/12/3 15:36
 */
@Component
public class MarketingStrategyModifyAdjustBudgetRepository extends ServiceImpl<MarketingStrategyModifyAdjustBudgetMapper, MarketingStrategyModifyAdjustBudget> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    
    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyModifyAdjustBudgetDto> findDtoListByModifyCode(String strategyCode){
        if (StringUtils.isBlank(strategyCode)){
            return null;
        }
        List<MarketingStrategyModifyAdjustBudget> list = findListByModifyCode(strategyCode);
        List<MarketingStrategyModifyAdjustBudgetDto> dtoList = (List<MarketingStrategyModifyAdjustBudgetDto>) nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetDto.class, HashSet.class, ArrayList.class);
        return dtoList;
    }

    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyModifyAdjustBudgetVo> findVoListByModifyCode(String strategyCode){
        if (StringUtils.isBlank(strategyCode)){
            return null;
        }
        List<MarketingStrategyModifyAdjustBudget> list = findListByModifyCode(strategyCode);
        List<MarketingStrategyModifyAdjustBudgetVo> dtoList = (List<MarketingStrategyModifyAdjustBudgetVo>) nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetVo.class, HashSet.class, ArrayList.class);
        return dtoList;
    }

    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyModifyAdjustBudgetVo> findVoListByModifyCodeList(List<String> strategyCodeList){
        if (CollectionUtils.isEmpty(strategyCodeList)){
            return null;
        }
        List<MarketingStrategyModifyAdjustBudget> list = findListByModifyCodeList(strategyCodeList);
        List<MarketingStrategyModifyAdjustBudgetVo> dtoList = (List<MarketingStrategyModifyAdjustBudgetVo>) nebulaToolkitService.copyCollectionByWhiteList(list, MarketingStrategyModifyAdjustBudget.class, MarketingStrategyModifyAdjustBudgetVo.class, HashSet.class, ArrayList.class);
        return dtoList;
    }

    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyModifyAdjustBudget> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return null;
        }

        MarketingStrategyModifyAdjustBudgetDto dto = new MarketingStrategyModifyAdjustBudgetDto();
        dto.setModifyBusinessCode(modifyCode);
        return findList(dto);
    }
    /**
     * 根据策略编码查询策略明细列表
     */
    public List<MarketingStrategyModifyAdjustBudget> findListByModifyCodeList(List<String> modifyCodeList) {
        if (CollectionUtils.isEmpty(modifyCodeList)){
            return null;
        }

        MarketingStrategyModifyAdjustBudgetDto dto = new MarketingStrategyModifyAdjustBudgetDto();
        dto.setModifyBusinessCodeList(modifyCodeList);
        return findList(dto);
    }

    /**
     * 根据查询条件筛选集合
     * @param dto 查询参数
     */
    public List<MarketingStrategyModifyAdjustBudget> findList(MarketingStrategyModifyAdjustBudgetDto dto) {
        LambdaQueryWrapper<MarketingStrategyModifyAdjustBudget> wrapper = Wrappers.lambdaQuery(MarketingStrategyModifyAdjustBudget.class)
                .eq(StringUtils.isNotBlank(dto.getModifyBusinessCode()), MarketingStrategyModifyAdjustBudget::getModifyBusinessCode, dto.getModifyBusinessCode())
                .eq(MarketingStrategyModifyAdjustBudget::getTenantCode, TenantUtils.getTenantCode())
                .eq(MarketingStrategyModifyAdjustBudget::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        if (!CollectionUtils.isEmpty(dto.getModifyBusinessCodeList())){
            wrapper.in(MarketingStrategyModifyAdjustBudget::getModifyBusinessCode,dto.getModifyBusinessCodeList());
        }
        return this.list(wrapper);
    }

    public void deleteByModifyBusinessCodes(ArrayList<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(modifyBusinessCodeList)){
            return;
        }
        LambdaUpdateWrapper<MarketingStrategyModifyAdjustBudget> updateWrapper = new UpdateWrapper<MarketingStrategyModifyAdjustBudget>().lambda();
//        updateWrapper.set(MarketingStrategyBudgetModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyModifyAdjustBudget::getModifyBusinessCode, modifyBusinessCodeList);
        updateWrapper.eq(MarketingStrategyModifyAdjustBudget::getTenantCode, TenantUtils.getTenantCode());
        this.remove(updateWrapper);
    }
}
