package com.biz.crm.tpm.business.marketing.strategy.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.mapper.MarketingStrategyModifyMapper;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 营销策略变更
 * @author wanghaojia
 * @date 2022/12/3 15:36
 */
@Component
public class MarketingStrategyModifyRepository extends ServiceImpl<MarketingStrategyModifyMapper, MarketingStrategyModify> {

    @Autowired(required = false)
    private MarketingStrategyModifyMapper marketingStrategyModifyMapper;

    public Page<MarketingStrategyModifyVo> findByConditions(Page<MarketingStrategyModifyVo> page, MarketingStrategyModifyDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.baseMapper.findByConditions(page, dto);
    }

    public void deleteIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper<MarketingStrategyModify> updateWrapper = new UpdateWrapper<MarketingStrategyModify>().lambda();
        updateWrapper.set(MarketingStrategyModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(MarketingStrategyModify::getId, ids);
        this.update(updateWrapper);
    }

    public void updateProcessStatusAndProcessNo(String modifyBusinessCode, String processStatus, String processNo) {
        if (StringUtils.isEmpty(modifyBusinessCode)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(MarketingStrategyModify.class)
                .set(MarketingStrategyModify::getProcessStatus, processStatus)
                .set(MarketingStrategyModify::getProcessNo, processNo)
                .in(MarketingStrategyModify::getModifyBusinessCode, modifyBusinessCode)
                .eq(MarketingStrategyModify::getTenantCode, TenantUtils.getTenantCode())
        );
    }


    /**
     * 更新流程状态
     * @param businessNo 业务数据编码
     * @param processStatus 流程状态
     */
    public void updateProcessStatus(String businessNo, String processStatus) {
        if (StringUtils.isEmpty(businessNo)) {
            return;
        }
        this.update(Wrappers.lambdaUpdate(MarketingStrategyModify.class)
                .set(MarketingStrategyModify::getProcessStatus, processStatus)
                .in(MarketingStrategyModify::getModifyBusinessCode, businessNo)
                .eq(MarketingStrategyModify::getTenantCode, TenantUtils.getTenantCode())

        );
    }

}
