package com.biz.crm.tpm.business.marketing.strategy.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyModifyFieldValue;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.*;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import org.springframework.data.domain.Pageable;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 营销策略调整明细服务
 * @author wanghaojia
 * @date 2022/12/6 09:37
 */
public interface MarketingStrategyItemModifyService extends MnPageCacheService<MarketingStrategyItemModifyVo, MarketingStrategyItemModifyDto> {


    /**
     * 保存营销策略变更明细
     * @param entity 头表数据
     * @param update 是否更新
     * @param itemList 明细数据
     */
    void saveMarketingStrategyModifyItemList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemList);

    void saveMarketingStrategyModifyItemList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemList, boolean validate);

    void createValidateList(MarketingStrategyModifyDto dto, List<MarketingStrategyItemModifyDto> dtoList);

    void createValidate(MarketingStrategyItemModifyDto dto);

    /**
     * 1、获取明细列表分页接口
     * @param cacheKey 缓存key
     * @param dto 查询参数
     * @return
     */
    void initToModifyList(String cacheKey, MarketingStrategyToModifyDto dto);

    /**
     * 获取缓存的数据 预算汇总信息
     */
    List<MarketingStrategyBudgetSumVo> findBudgetCacheSumList(String cacheKey);

    /**
     * 分页查询调整前数据
     * @param dto
     * @return
     */
    Page<MarketingStrategyItemModifyVo> findItemBeforeModifyList(Pageable pageable, MarketingStrategyItemModifyDto dto);

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    Page<MarketingStrategyItemModifyVo> findByConditions(Pageable pageable, MarketingStrategyItemModifyDto dto);


    /**
     * 通过编码编码删除变更策略明细
     * @param modifyCodes
     */
    void deleteByModifyCodes(List<String> modifyCodes);

    /**
     * 策略调整差异对比
     */
    Page<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueList(Pageable pageable, MarketingStrategyItemModifyDto dto) throws InvocationTargetException, IllegalAccessException;

    List<MarketingStrategyModifyAdjustBudgetVo> findAdjustBudgetVoListByModifyCode(String modifyBusinessCode);

    List<MarketingStrategyModifyAdjustBudgetVo> findAdjustBudgetVoListByProcessNo(String processNo);

    void useMonthBudgetByModifyCode(String modifyCode);

    List<OperateMonthBudgetDto> useMonthBudget(List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList,List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos);

    List<OperateMonthBudgetDto> useMonthBudget(List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList,List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos,boolean doSave, boolean throwException);

    void returnMonthBudgetByModifyCode(String modifyCode);

    void doUpdatePlanData(String modifyCode);

    List<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws InvocationTargetException, IllegalAccessException;

}
