package com.biz.crm.tpm.business.marketing.strategy.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 营销策略变更接口
 * @author wanghaojia
 * @date 2022/12/3 10:25
 */
public interface MarketingStrategyModifyService {

    /**
     * 分页查询
     * @param pageable
     * @param dto
     * @return
     */
    Page<MarketingStrategyModifyVo> findByConditions(Pageable pageable, MarketingStrategyModifyDto dto);

    Result<List<MarketingStrategyModifyAdjustBudgetVo>> validateMarketingStrategyModify(MarketingStrategyModifyDto dto, String cacheKey);

    /**
     * 保存营销策略调整数据
     * @param dto 表头数据
     * @param cacheKey 缓存key
     */
    void saveMarketingStrategyModify(MarketingStrategyModifyDto dto, String cacheKey);

    /**
     * 获取策略变更头表数据
     */
    MarketingStrategyModifyVo findById(String id);

    /**
     * 删除营销策略调整数据
     * @param ids
     */
    void delete(List<String> ids);

    /**
     * 策略调整提交审批
     */
    void submit(MarketingStrategyModifyApproveSubmitDto dto);

    void processPass(ProcessStatusDto dto);

    void processRejectAndRecover(ProcessStatusDto dto);

}
