package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyBudgetModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyBudgetModifyService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案预算
 * @author wanghaojia
 * @date 2023/1/10 20:37
 */
@Service
public class MarketingStrategyBudgetModifyServiceImpl implements MarketingStrategyBudgetModifyService {


    @Autowired(required = false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param itemDtoList  活动方案关联预算数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveMarketingStrategyBudgetList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemDtoList) {
//        Map<String, MarketingStrategyBudgetModifyDto> oldMap = Maps.newHashMap();
        if (update){
//            List<MarketingStrategyBudgetModifyDto> oldDtoList = marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(entity.getModifyBusinessCode());
//            oldMap = oldDtoList.stream().collect(Collectors.toMap(item -> {
//                return item.getStrategyItemCode() + item.getMonthBudgetCode() ;
//            }, Function.identity()));
            marketingStrategyBudgetModifyRepository.deleteByModifyBusinessCodes(Lists.newArrayList(entity.getModifyBusinessCode()));
        }

        List<MarketingStrategyBudgetModify> list = Lists.newArrayList();
        for (MarketingStrategyItemModifyDto itemDto : itemDtoList) {
            List<MarketingStrategyBudgetModify> budgetList = Lists.newArrayList();
            List<MarketingStrategyBudgetModifyDto> budgetShares = itemDto.getBudgetShares();
            if (!CollectionUtils.isEmpty(budgetShares)){
                Collection<MarketingStrategyBudgetModify> budgetShareEntityList = nebulaToolkitService.copyCollectionByWhiteList(budgetShares, MarketingStrategyBudgetModifyDto.class, MarketingStrategyBudgetModify.class, HashSet.class, ArrayList.class);
                for (MarketingStrategyBudgetModify monthBudget : budgetShareEntityList) {
                    monthBudget.setModifyBusinessCode(entity.getModifyBusinessCode());
                    monthBudget.setStrategyCode(itemDto.getStrategyCode());
                    monthBudget.setStrategyItemCode(itemDto.getStrategyItemCode());
                }
                budgetList.addAll(budgetShareEntityList);
            }
            list.addAll(budgetList);
        }


        List<MarketingStrategyBudgetModify> saveList = Lists.newArrayList();
        List<MarketingStrategyBudgetModify> updateList = Lists.newArrayList();
        for (MarketingStrategyBudgetModify item : list) {
            String key = item.getStrategyItemCode() + item.getMonthBudgetCode();
//            if (oldMap.containsKey(key)){
//                item.setId(oldMap.get(key).getId());
//                updateList.add(item);
//                oldMap.remove(key);
//            }else{
                item.setModifyBusinessCode(entity.getModifyBusinessCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
//            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            marketingStrategyBudgetModifyRepository.saveBatch(saveList);
        }
//        if (!CollectionUtils.isEmpty(updateList)){
//            marketingStrategyBudgetModifyRepository.updateBatchById(updateList);
//        }
//        if (oldMap.size() > 0){
//            //待删除的数据
//            List<String> deleteIds = oldMap.values().stream().map(MarketingStrategyBudgetModifyDto::getId).collect(Collectors.toList());
//            marketingStrategyBudgetModifyRepository.deleteByIds(deleteIds);
//        }
    }

    @Override
    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        marketingStrategyBudgetModifyRepository.deleteByModifyBusinessCodes(modifyBusinessCodeList);
    }


}
