package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyItemModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModifyAdjustBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyBudgetModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyModifyAdjustBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyItemModifyService;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyItemModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyModifyFieldValue;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.*;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyModifyAdjustBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2022/12/6 09:39
 */
@Slf4j
@Service
public class MarketingStrategyItemModifyServiceImpl extends MnPageCacheServiceImpl<MarketingStrategyItemModifyVo, MarketingStrategyItemModifyDto> implements MarketingStrategyItemModifyService {

    @Autowired(required = false)
    private MarketingStrategyItemModifyRepository marketingStrategyItemModifyRepository;

    @Autowired(required = false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;

    @Autowired(required = false)
    private MarketingStrategyRepository marketingStrategyRepository;
    @Autowired(required = false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;

    @Autowired(required = false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;
    @Autowired(required = false)
    private MarketingStrategyModifyAdjustBudgetRepository marketingStrategyModifyAdjustBudgetRepository;

    @Autowired(required = false)
    private MarketingStrategyModifyPageCacheHelper pageCacheHelper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisService redisService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    /**
     * 销量任务服务
     */
    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<MarketingStrategyItemModifyVo> findByConditions(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        return marketingStrategyItemModifyRepository.findByConditions(pageable,dto);
    }

    /**
     * 通过编码编码删除变更策略明细
     * @param modifyCodes
     */
    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        marketingStrategyItemModifyRepository.deleteByModifyCodes(modifyCodes);
    }

    /**
     * 分页查询调整前数据
     * @param dto
     * @return
     */
    @Override
    public Page<MarketingStrategyItemModifyVo> findItemBeforeModifyList(Pageable pageable, MarketingStrategyItemModifyDto dto) {
        return marketingStrategyItemModifyRepository.findItemBeforeModifyList(pageable,dto);
    }

    @Override
    public void saveMarketingStrategyModifyItemList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemList) {
        saveMarketingStrategyModifyItemList(entity,update,itemList,true);
    }

    @Override
    public void saveMarketingStrategyModifyItemList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyItemModifyDto> itemList, boolean validate) {
        if (validate){
            MarketingStrategyModifyDto dto = new MarketingStrategyModifyDto();
            dto.setBusinessUnitCode(entity.getBusinessUnitCode());
            this.createValidateList(dto,itemList);
        }

        backupInitVersionData(itemList);

        List<MarketingStrategyItemModify> marketingStrategyItems = (List<MarketingStrategyItemModify>) nebulaToolkitService.copyCollectionByBlankList(itemList, MarketingStrategyItemModifyDto.class, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class);


        Map<String, MarketingStrategyItemModify> oldMap = Maps.newHashMap();
        if (update){
            List<MarketingStrategyItemModify> oldList = marketingStrategyItemModifyRepository.findListByModifyCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(MarketingStrategyItemModify::getId, Function.identity()));
        }
        List<MarketingStrategyItemModify> saveList = Lists.newArrayList();
        List<MarketingStrategyItemModify> updateList = Lists.newArrayList();
        for (MarketingStrategyItemModify item : marketingStrategyItems) {
            if (oldMap.containsKey(item.getId())){
                updateList.add(item);
                oldMap.remove(item.getId());
            }else{
                item.setModifyBusinessCode(entity.getModifyBusinessCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);//id置空
                saveList.add(item);
            }
        }
        //先删除才能保存
        if (oldMap.size() > 0){
            //待删除的数据
            marketingStrategyItemModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
        if (!CollectionUtils.isEmpty(saveList)){
            marketingStrategyItemModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            marketingStrategyItemModifyRepository.updateBatchById(updateList);
        }
    }

    private void backupInitVersionData(List<MarketingStrategyItemModifyDto> itemList) {
        List<String> itemCodeList = itemList.stream().map(MarketingStrategyItemModifyDto::getStrategyItemCode).collect(Collectors.toList());
        List<MarketingStrategyItem> noModifyList = marketingStrategyItemRepository.list(
                Wrappers.<MarketingStrategyItem>lambdaQuery()
                        .in(MarketingStrategyItem::getStrategyItemCode, itemCodeList)
                        .and(w -> {
                            w.eq(MarketingStrategyItem::getHasModify, BooleanEnum.FALSE.getCapital());
                            w.or();
                            w.isNull(MarketingStrategyItem::getHasModify);
                        })
        );
        if (CollectionUtils.isEmpty(noModifyList)){
            //不是第一次变更，已经备份过了
            return;
        }
        List<MarketingStrategyItemModify> entityList = (List<MarketingStrategyItemModify>) nebulaToolkitService.copyCollectionByBlankList(noModifyList, MarketingStrategyItem.class, MarketingStrategyItemModify.class, HashSet.class, ArrayList.class);
        marketingStrategyItemModifyRepository.saveBatch(entityList);

        List<String> noModifyCodeList = noModifyList.stream().map(MarketingStrategyItem::getStrategyItemCode).collect(Collectors.toList());
        marketingStrategyItemRepository.update(
                Wrappers.<MarketingStrategyItem>lambdaUpdate()
                        .set(MarketingStrategyItem::getHasModify,BooleanEnum.TRUE.getCapital())
                        .in(MarketingStrategyItem::getStrategyItemCode, noModifyCodeList)
        );

        List<MarketingStrategyBudget> budgetList = marketingStrategyBudgetRepository.lambdaQuery()
                .eq(MarketingStrategyBudget::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .in(MarketingStrategyBudget::getStrategyItemCode, noModifyCodeList).list();

        if (!CollectionUtils.isEmpty(budgetList)){
            List<MarketingStrategyBudgetModify> budgetModifyList = (List<MarketingStrategyBudgetModify>) nebulaToolkitService.copyCollectionByBlankList(budgetList, MarketingStrategyBudget.class, MarketingStrategyBudgetModify.class, HashSet.class, ArrayList.class);
            marketingStrategyBudgetModifyRepository.saveBatch(budgetModifyList);
        }
    }


    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dtoList 营销策略明细数据
     */
    @Override
    public void createValidateList(MarketingStrategyModifyDto dto, List<MarketingStrategyItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        for (MarketingStrategyItemModifyDto item : dtoList) {
            this.createValidate(item);
        }
        //主体跨月逻辑校验
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())){
            for (MarketingStrategyItemModifyDto item : dtoList) {
                DateStringDealUtil.validateDateStrAndSet(item.getBeginDateStr(),"新增时，策略明细开始时间不能为空", true, DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setBeginDate);
                DateStringDealUtil.validateDateStrAndSet(item.getEndDateStr(),"新增时，策略明细结束时间不能为空", true,DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setEndDate);
                Validate.notBlank(item.getBudgetItemCode(),"新增时，策略预算项目不能为空");
            }
            List<String> budgetItemCodeList = dtoList.stream().map(MarketingStrategyItemModifyDto::getBudgetItemCode).distinct().collect(Collectors.toList());
            List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(budgetItemCodeList);
            if (CollectionUtils.isEmpty(budgetItemVos)){
                throw new RuntimeException("预算项目查询失败！");
            }
            Map<String, BudgetItemVo> budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            Calendar calendar = Calendar.getInstance();
            for (MarketingStrategyItemModifyDto item : dtoList) {
                String allowAcrossMonth = BooleanEnum.FALSE.getCapital();//默认不允许跨月
                BudgetItemVo budgetItemVo = budgetItemMap.get(item.getBudgetItemCode());
                if (null == budgetItemVo){
                    throw new RuntimeException("预算项目["+item.getBudgetItemCode()+"]有误！");
                }
                if (StringUtils.isNotEmpty(budgetItemVo.getAllowCrossMonth())){
                    allowAcrossMonth = budgetItemVo.getAllowCrossMonth();
                }
                if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)){
                    continue;
                }
                //此预算项目不允许跨月使用，请修改策略开始时间、策略结束时间！
                int year = Integer.parseInt(item.getStrategyYearMonth().substring(0,4));
                int month = Integer.parseInt(item.getStrategyYearMonth().substring(5))-1;
                calendar.setTime(item.getBeginDate());
                if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)){
                    throw new RuntimeException("预算项目["+item.getBudgetItemCode()+"]不允许跨月使用，请修改策略开始时间、策略结束时间！");
                }
                calendar.setTime(item.getEndDate());
                if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)){
                    throw new RuntimeException("预算项目["+item.getBudgetItemCode()+"]不允许跨月使用，请修改策略开始时间、策略结束时间！");
                }
            }
            if (!CollectionUtils.isEmpty(dto.getAdjustBudgetList())){
                for (MarketingStrategyModifyAdjustBudgetDto adjustBudgetDto : dto.getAdjustBudgetList()) {
                    Validate.notBlank(adjustBudgetDto.getMonthBudgetCode(),"调入方预算编码不能为空");
                    Validate.notBlank(adjustBudgetDto.getAdjustOutMonthBudgetCode(),"调出方预算编码不能为空");
                    Validate.isTrue(!adjustBudgetDto.getMonthBudgetCode().equals(adjustBudgetDto.getAdjustOutMonthBudgetCode()),"调入方预算编码不能与调出方预算编码相同");
                }
            }
        }
    }

    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dto 营销策略明细数据
     */
    @Override
    public void createValidate(MarketingStrategyItemModifyDto dto) {
        Validate.notBlank(dto.getActivityTypeCode(), "策略明细活动类型不能为空");
//        Validate.notBlank(dto.getActivityFormCode(), "新增时，策略明细活动形式不能为空");
        Validate.notBlank(dto.getStrategyOrgCode(), "策略明细区域不能为空");
//        Validate.notBlank(dto.getStrategyYearMonth(), "策略明细年月不能为空");
        NumberStringDealUtil.validateNumberStrAndSet(dto.getActivityNumberStr(), "策略明细活动场次", false, dto::setActivityNumber, Integer.class);
        NumberStringDealUtil.validateNumberStrAndSet(dto.getQuantityStr(), "策略明细数量", false, dto::setQuantity, Integer.class);
        NumberStringDealUtil.validateNumberStrAndSet(dto.getFeeAmountStr(), "策略明细费用金额", true, dto::setFeeAmount, BigDecimal.class);
    }


    @Override
    public void initToModifyList(String cacheKey, MarketingStrategyToModifyDto dto) {
//        业态：1）根据创建人的组织自动带出业态；2）如果不能带出数据：下拉单选框、必填项，提交时校验不能为空；下拉选项值（数据字典）：常温、低温、冰品等，支持扩展。
//        业务单元：1）根据创建人的组织自动带出业务单元；2）如果不能带出数据：下拉单选框、必填项，提交时校验不能为空；下拉选项值（数据字典）：主体、分子公司、垂直重客、电商等，支持扩展。
//        归属部门：1）根据创建人的组织自动带出归属部门；2）如果不能带出数据：下拉单选框、必填项，提交时校验不能为空；下拉选项值（数据字典）：渠道管理部、行销策略管理部、重点客户部、运营管理部等，支持扩展
//        预算项目选择：下拉复选框，必填项，数据来源于预算项目列表数据；
//        时间选择：时间选择器，多选，必填项；
//        调整说明：文本框，非必填字段；
        Validate.notBlank(dto.getBusinessFormatCode(),"业态不能为空");
        Validate.notBlank(dto.getBusinessUnitCode(),"业务单元不能为空");
//        需增加一下条件，当填策略编码或策略明细编码时，归属部门、预算项目、时间选择可不必填。当没有填策略编码和策略明细编码时。按原先的逻辑都应必填。
        if (StringUtils.isEmpty(dto.getStrategyCode()) && StringUtils.isEmpty(dto.getStrategyItemCode())){
            Validate.notBlank(dto.getAttrOrgCode(),"归属部门不能为空");
            Validate.notBlank(dto.getBudgetItemCode(),"预算项目不能为空");
            Validate.notBlank(dto.getStrategyYearMonth(),"策略年月不能为空");
        }
        if (StringUtils.isNotBlank(dto.getBudgetItemCode())){
            dto.setBudgetItemCodeList(Arrays.asList(dto.getBudgetItemCode().split(",")));
        }
        if (StringUtils.isNotBlank(dto.getStrategyCode())){
            dto.setStrategyCodeList(Arrays.asList(dto.getStrategyCode().split(",")));
        }
        if (StringUtils.isNotBlank(dto.getStrategyItemCode())){
            dto.setStrategyItemCodeList(Arrays.asList(dto.getStrategyItemCode().split(",")));
        }
        if (StringUtils.isNotBlank(dto.getStrategyYearMonth())){
            dto.setStrategyYearMonthList(Arrays.asList(dto.getStrategyYearMonth().split(",")));
        }
        List<MarketingStrategyItemModifyDto> toModifyList = marketingStrategyItemModifyRepository.findToModifyList(dto);
        clearCache(cacheKey);
        if (!CollectionUtils.isEmpty(toModifyList)){
            pageCacheHelper.putCache(cacheKey,toModifyList);
        }
    }

    @Override
    public List<MarketingStrategyBudgetSumVo> findBudgetCacheSumList(String cacheKey) {
        List<MarketingStrategyItemModifyDto> itemList = super.findCacheList(cacheKey);
        Map<String, MarketingStrategyBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (MarketingStrategyItemModifyDto item : itemList) {
            if (StringUtils.isEmpty(item.getMonthBudgetCode())) {
                continue;
            }
            //预算不为空才处理
            MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), (key) -> new MarketingStrategyBudgetSumVo() {{
                this.setTotalStrategyAmount(BigDecimal.ZERO);
                this.setInitResolveAmount(BigDecimal.ZERO);
                this.setUsedStrategyAmount(BigDecimal.ZERO);
                this.setCanApplyStrategyAmount(BigDecimal.ZERO);
            }});
            budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
            budgetSumVo.setBudgetItemName(item.getBudgetItemName());
            if (null != item.getFeeAmount()) {
                budgetSumVo.setTotalStrategyAmount(budgetSumVo.getTotalStrategyAmount().add(item.getFeeAmount()));
            }
            feeBudgetCodeSet.add(item.getMonthBudgetCode());
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            for (MonthBudgetVo budgetVo : budgetVos) {
                MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                if (null != budgetVo.getInitResolveAmount()) {
                    budgetSumVo.setInitResolveAmount(budgetVo.getInitResolveAmount());
                }
                if (null != budgetVo.getMonthRollingAmount()) {
                    budgetSumVo.setMonthRollingAmount(budgetVo.getMonthRollingAmount());
                }
                if (null != budgetVo.getLastMonthRollingAmount()) {
                    budgetSumVo.setLastMonthRollingAmount(budgetVo.getLastMonthRollingAmount());
                }
                if (null != budgetVo.getAfterFreezeAmount()) {
                    budgetSumVo.setAfterFreezeAmount(budgetVo.getAfterFreezeAmount());
                }
                if (null != budgetVo.getUsedStrategyAmount()) {
                    budgetSumVo.setUsedStrategyAmount(budgetVo.getUsedStrategyAmount());
                }
            }
        }
        List<MarketingStrategyBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        budgetSumList.forEach(item -> {
            item.setCanApplyStrategyAmount(Optional.ofNullable(item.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(
                    Optional.ofNullable(item.getUsedStrategyAmount()).orElse(BigDecimal.ZERO))
            );
        });

        return budgetSumList;
    }

    @Override
    public List<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws IllegalAccessException, InvocationTargetException {
        Pageable tempPageable = PageRequest.of(1, 999999);

        List<String> businessNoList = this.findModifyBusinessNoListByProcessNo(processNo);

        MarketingStrategyItemModifyDto marketingStrategyItemModifyDto = new MarketingStrategyItemModifyDto();
        marketingStrategyItemModifyDto.setModifyBusinessCodeList(businessNoList);
        Page<MarketingStrategyItemModifyVo> itemBeforeModifyPage = findItemBeforeModifyList(tempPageable, marketingStrategyItemModifyDto);
        Page<MarketingStrategyItemModifyVo> itemModifyPage = findByConditions(tempPageable, marketingStrategyItemModifyDto);
        List<MarketingStrategyItemModifyVo> itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List<MarketingStrategyItemModifyVo> itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty(itemBeforeModifyList)) {
            return Lists.newArrayList();
        }

        return findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
    }

    /**
     * 根据流程编码查询变更编码
     * @param processNo 流程编码
     * @return 策略变更编码
     */
    private List<String> findModifyBusinessNoListByProcessNo(String processNo){
        //查到调整前后的数据一个一个对比吧，对比完了再分页
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty(processBusinessMappingVoList)){
            throw new RuntimeException("流程数据有误！");
        }
        return processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }

    @Override
    public Page<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueList(Pageable pageable, MarketingStrategyItemModifyDto dto) throws InvocationTargetException, IllegalAccessException {
        Page<MarketingStrategyModifyFieldValue> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page.setTotal(0);
        page.setRecords(Lists.newArrayList());
        
        
        //查到调整前后的数据一个一个对比吧，对比完了再分页
        Pageable tempPageable = PageRequest.of(1, 999999);
        Page<MarketingStrategyItemModifyVo> itemBeforeModifyPage = findItemBeforeModifyList(tempPageable, dto);
        Page<MarketingStrategyItemModifyVo> itemModifyPage = findByConditions(tempPageable, dto);
        List<MarketingStrategyItemModifyVo> itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List<MarketingStrategyItemModifyVo> itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty(itemBeforeModifyList)) {
            return page;
        }

        List<MarketingStrategyModifyFieldValue> modifyFieldValueList = findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
        //放到缓存里面
        page.setTotal(modifyFieldValueList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List<MarketingStrategyModifyFieldValue> recordList = modifyFieldValueList.subList((int) page.offset(), (int) end);
            page.setRecords(recordList);
        }

        return page;
    }
    
    public List<MarketingStrategyModifyFieldValue> findItemModifyLFieldValueList(List<MarketingStrategyItemModifyVo> itemModifyList,List<MarketingStrategyItemModifyVo> itemBeforeModifyList) throws InvocationTargetException, IllegalAccessException {
        Map<String, MarketingStrategyItemModifyVo> itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(MarketingStrategyItemModifyVo::getStrategyItemCode, Function.identity()));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(MarketingStrategyItemModifyVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Map<String,String> modifyFieldMap = Maps.newHashMap();
        modifyFieldMap.put("strategyName","策略名称");
        modifyFieldMap.put("strategyTitle","策略主题");
        modifyFieldMap.put("strategyDesc","策略描述");
        modifyFieldMap.put("strategyOrgCode","区域编码");
        modifyFieldMap.put("strategyOrgName","区域名称");
        modifyFieldMap.put("beginDateStr","策略开始时间");
        modifyFieldMap.put("endDateStr","策略结束时间");
        modifyFieldMap.put("firstChannelCode","一级管理渠道编码");
        modifyFieldMap.put("firstChannelName","一级管理渠道名称");
        modifyFieldMap.put("secondChannelCode","二级管理渠道编码");
        modifyFieldMap.put("secondChannelName","二级管理渠道名称");
        modifyFieldMap.put("systemCode","系统/零售商编码");
//        modifyFieldMap.put("systemName","系统/零售商名称");
        modifyFieldMap.put("productBrandCode","品牌编码");
        modifyFieldMap.put("productBrandName","品牌名称");
        modifyFieldMap.put("activityTypeCode","活动类型编码");
        modifyFieldMap.put("activityTypeName","活动类型名称");
        modifyFieldMap.put("activityFormCode","活动形式编码");
        modifyFieldMap.put("activityFormName","活动形式名称");
        modifyFieldMap.put("activityIntensity","活动力度");
        modifyFieldMap.put("activityNumber","活动场次");
        modifyFieldMap.put("quantity","数量");
        modifyFieldMap.put("feeAmount","费用金额（元）");
        modifyFieldMap.put("controlRatio","控制系数");

        List<MarketingStrategyModifyFieldValue> modifyFieldValueList = Lists.newArrayList();
        for (MarketingStrategyItemModifyVo itemVo : itemBeforeModifyList) {
            MarketingStrategyItemModifyVo itemModifyVo = itemModifyMap.get(itemVo.getStrategyItemCode());

            for (Map.Entry<String, String> entry : modifyFieldMap.entrySet()) {
                String fieldName = entry.getKey();
                String fieldTitle = entry.getValue();
                PropertyDescriptor propertyDescriptor = propertyMap.get(fieldName);
                Object beforeFieldValue = propertyDescriptor.getReadMethod().invoke(itemVo);
                Object fieldValue = propertyDescriptor.getReadMethod().invoke(itemModifyVo);
                if (null == beforeFieldValue && null == fieldValue){
                    //变更前后都是空，跳过
                    continue;
                }

                MarketingStrategyModifyFieldValue modifyFieldValue = new MarketingStrategyModifyFieldValue();
                modifyFieldValue.setStrategyCode(itemVo.getStrategyCode());
                modifyFieldValue.setStrategyItemCode(itemVo.getStrategyItemCode());
                modifyFieldValue.setFieldName(fieldName);
                modifyFieldValue.setFieldTitle(fieldTitle);
                if (null != beforeFieldValue && null != fieldValue){
                    //变更前后都不为空
                    if (beforeFieldValue.equals(fieldValue)){
                        //相等，跳过
                        continue;
                    }else if (propertyDescriptor.getPropertyType() == Integer.class){
                        Integer beforeFieldValueInt = (Integer) beforeFieldValue;
                        Integer fieldValueInt = (Integer) fieldValue;
                        if (beforeFieldValueInt.compareTo(fieldValueInt) == 0){
                            continue;//相等，跳过
                        }
                    }else if (propertyDescriptor.getPropertyType() == BigDecimal.class){
                        BigDecimal beforeFieldValueBigDecimal = (BigDecimal) beforeFieldValue;
                        BigDecimal fieldValueBigDecimal = (BigDecimal) fieldValue;
                        if (beforeFieldValueBigDecimal.compareTo(fieldValueBigDecimal) == 0){
                            continue;//相等，跳过
                        }
                    }
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }else if (null != beforeFieldValue){
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                }else {
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }
                modifyFieldValueList.add(modifyFieldValue);
            }
        }
        return modifyFieldValueList;
    }

    @Override
    public List<MarketingStrategyModifyAdjustBudgetVo> findAdjustBudgetVoListByModifyCode(String modifyBusinessCode) {
        return marketingStrategyModifyAdjustBudgetRepository.findVoListByModifyCode(modifyBusinessCode);
    }

    @Override
    public List<MarketingStrategyModifyAdjustBudgetVo> findAdjustBudgetVoListByProcessNo(String processNo) {
        List<String> businessNoList = findModifyBusinessNoListByProcessNo(processNo);
        if (CollectionUtils.isEmpty(businessNoList)){
            return Lists.newArrayList();
        }
        return marketingStrategyModifyAdjustBudgetRepository.findVoListByModifyCodeList(businessNoList);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode) {
        List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList = marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(modifyCode);
        List<MarketingStrategyModifyAdjustBudgetDto> dtoListByModifyCode = marketingStrategyModifyAdjustBudgetRepository.findDtoListByModifyCode(modifyCode);
        useMonthBudget(modifyItemBudgetList,dtoListByModifyCode);
    }

    @Override
    public List<OperateMonthBudgetDto> useMonthBudget(List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList,List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos) {
        return useMonthBudget(modifyItemBudgetList,adjustBudgetDtos,true,true);
    }

    @Override
    public List<OperateMonthBudgetDto> useMonthBudget(List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList,List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos,boolean doSave,boolean throwException) {
        List<String> itemCodeList = modifyItemBudgetList.stream().map(MarketingStrategyBudgetModifyDto::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> originBudgetList = marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> {
            return item.getStrategyItemCode() + item.getMonthBudgetCode();
        }, MarketingStrategyBudgetDto::getUseAmount));

        Map<String,BigDecimal> looseAmountMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(adjustBudgetDtos)){
            List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
            for (MarketingStrategyModifyAdjustBudgetDto adjustBudget : adjustBudgetDtos) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){{
                    this.setBusinessCode(adjustBudget.getModifyBusinessCode());
                    this.setMonthBudgetCode(adjustBudget.getAdjustOutMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.ADJUST_OUT.getCode());
                    this.setOperationAmount(adjustBudget.getAdjustAmount());
                    this.setDoSave(doSave);
                    this.setThrowException(throwException);
                }};
                budgetOperateList.add(operateMonthBudgetDto);
                looseAmountMap.put(adjustBudget.getMonthBudgetCode(),adjustBudget.getAdjustAmount());
            }
            monthBudgetService.operateBudget(budgetOperateList);
        }

        //先统计一遍宽限金额
        for (MarketingStrategyBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getStrategyItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal operationAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
            if (operationAmount.compareTo(BigDecimal.ZERO) > 0){
                continue;//要退预算
            }
            String looseAmountKey = budgetShareModify.getMonthBudgetCode();
            looseAmountMap.put(looseAmountKey,looseAmountMap.getOrDefault(looseAmountKey,BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
        }

        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        for (MarketingStrategyBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getStrategyItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal operationAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
//            log.error("操作预算["+budgetShareModify.getMonthBudgetCode()+"]:操作金额["+operationAmount+"]本次使用金额:["+budgetShareModify.getUseAmount()+"]变更前金额:["+originUseAmount+"]调整金额:["+adjustAmount+"]");
            if (operationAmount.compareTo(BigDecimal.ZERO) <= 0){
                //不变或者是要退
                continue;
            }
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){{
                this.setBusinessCode(budgetShareModify.getStrategyItemCode());
                this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setDoSave(doSave);
                this.setThrowException(throwException);
            }};
            operateMonthBudgetDto.setOperationAmount(operationAmount);
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudgetStrategy(budgetOperateList,looseAmountMap);
        }
        return budgetOperateList;
    }


    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode) {
        List<MarketingStrategyItemModify> modifyItemList = marketingStrategyItemModifyRepository.findListByModifyCode(modifyCode);
        List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList = marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(modifyCode);
        List<String> itemCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> originBudgetList = marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> {
            return item.getStrategyItemCode() + item.getMonthBudgetCode();
        }, MarketingStrategyBudgetDto::getUseAmount));

        List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetDtos = marketingStrategyModifyAdjustBudgetRepository.findDtoListByModifyCode(modifyCode);

        if (!CollectionUtils.isEmpty(adjustBudgetDtos)){
            List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
            for (MarketingStrategyModifyAdjustBudgetDto adjustBudget : adjustBudgetDtos) {
                OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){{
                    this.setBusinessCode(adjustBudget.getModifyBusinessCode());
                    this.setMonthBudgetCode(adjustBudget.getAdjustOutMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RELEASE.getCode());
                    this.setOperationAmount(adjustBudget.getAdjustAmount());
                }};
                budgetOperateList.add(operateMonthBudgetDto);
            }
            monthBudgetService.operateBudget(budgetOperateList);
        }


        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        for (MarketingStrategyBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(budgetShareModify.getStrategyItemCode() + budgetShareModify.getMonthBudgetCode(), BigDecimal.ZERO);
            BigDecimal operationAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
//            log.error("操作预算["+budgetShareModify.getMonthBudgetCode()+"]:操作金额["+operationAmount+"]本次使用金额:["+budgetShareModify.getUseAmount()+"]变更前金额:["+originUseAmount+"]调整金额:["+adjustAmount+"]");
            if (operationAmount.compareTo(BigDecimal.ZERO) <= 0){
                //不变或者是要退
                continue;
            }
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){{
                this.setBusinessCode(budgetShareModify.getStrategyItemCode());
                this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
            }};
            operateMonthBudgetDto.setOperationAmount(operationAmount);
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudgetStrategy(budgetOperateList);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void doUpdatePlanData(String modifyCode) {
        List<MarketingStrategyItemModify> modifyItemList = marketingStrategyItemModifyRepository.findListByModifyCode(modifyCode);
        if (CollectionUtils.isEmpty(modifyItemList)){
            return;
        }
        List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList = marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(modifyCode);
        List<MarketingStrategyModifyAdjustBudget> adjustBudgets = marketingStrategyModifyAdjustBudgetRepository.findListByModifyCode(modifyCode);
        //如果有调整的预算，处理下
        passAdjustMonthBudget(adjustBudgets,modifyItemList,modifyItemBudgetList);

        //先退下减少的预算
        passReturnMonthBudgetByModifyCode(modifyItemList,modifyItemBudgetList);

        Map<String, MarketingStrategyItemModify> modifyMap = modifyItemList.stream().collect(Collectors.toMap(MarketingStrategyItemModify::getStrategyItemCode, Function.identity()));
        List<String> itemCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyItem> itemList = marketingStrategyItemRepository.findList(itemDto);

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        String[] ignoreFieldArr = Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).toArray(String[]::new);

        for (MarketingStrategyItem item : itemList) {
            MarketingStrategyItemModify modifyItem = modifyMap.get(item.getStrategyItemCode());
            BeanUtils.copyProperties(modifyItem,item,ignoreFieldArr);
            item.setCurrModifyBusinessCode(modifyItem.getModifyBusinessCode());
        }
        marketingStrategyItemRepository.updateBatchById(itemList);

        //预算也更新下
        MarketingStrategyItemDto queryBudgetDto = new MarketingStrategyItemDto();
        queryBudgetDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> marketingStrategyBudgetDtos = marketingStrategyBudgetRepository.listByStrategyItem(queryBudgetDto);
        Map<String, BigDecimal> usedAmountMap = marketingStrategyBudgetDtos.stream()
                .filter(item -> null != item.getUsedAmount())
                .collect(Collectors.groupingBy(item -> item.getStrategyItemCode() + item.getMonthBudgetCode(),
                        Collectors.reducing(BigDecimal.ZERO, MarketingStrategyBudgetDto::getUsedAmount, BigDecimal::add)));
        marketingStrategyBudgetRepository.deleteByStrategyItemCodes(itemCodeList);
        if (!CollectionUtils.isEmpty(modifyItemBudgetList)){
            Collection<MarketingStrategyBudget> budgetShareList = nebulaToolkitService.copyCollectionByBlankList(modifyItemBudgetList, MarketingStrategyBudgetModifyDto.class, MarketingStrategyBudget.class, HashSet.class, ArrayList.class);
            //设置已使用金额
            Map<String, List<MarketingStrategyBudget>> budgetShareMap = budgetShareList.stream().collect(Collectors.groupingBy(item -> item.getStrategyItemCode() + item.getMonthBudgetCode()));
            for (Map.Entry<String, BigDecimal> entry : usedAmountMap.entrySet()) {
                BigDecimal usedAmount = entry.getValue();
                if (usedAmount.compareTo(BigDecimal.ZERO) == 0){
                    continue;
                }
                List<MarketingStrategyBudget> thisBudgetShareList = budgetShareMap.get(entry.getKey());
                if (CollectionUtils.isEmpty(thisBudgetShareList)){
                    continue;//讲道理不应该有这种情况
                }
                for (MarketingStrategyBudget marketingStrategyBudget : thisBudgetShareList) {
                    if (marketingStrategyBudget.getUseAmount().compareTo(usedAmount) >= 0){
                        marketingStrategyBudget.setUsedAmount(Optional.ofNullable(marketingStrategyBudget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
                        usedAmount = BigDecimal.ZERO;
                    }else{
                        marketingStrategyBudget.setUsedAmount(marketingStrategyBudget.getUseAmount());
                        usedAmount = usedAmount.subtract(marketingStrategyBudget.getUseAmount());
                    }
                }
                if (usedAmount.compareTo(BigDecimal.ZERO) != 0){
                    MarketingStrategyBudget firstBudget = thisBudgetShareList.get(0);
                    firstBudget.setUsedAmount(Optional.ofNullable(firstBudget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
                }
            }
            marketingStrategyBudgetRepository.saveBatch(budgetShareList);
        }
        //再更新下策略上的费用总金额
        List<String> strategyCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyCode).distinct().collect(Collectors.toList());
        marketingStrategyRepository.updateFeeAmount(strategyCodeList);
    }

    /**
     * 有预算调整的
     * @param adjustBudgets 调整的预算信息
     * @param modifyItemBudgetList 调整的策略信息
     */
    private void passAdjustMonthBudget(List<MarketingStrategyModifyAdjustBudget> adjustBudgets, List<MarketingStrategyItemModify> modifyItemList,List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList) {
        if (CollectionUtils.isEmpty(adjustBudgets)){
            return;
        }
        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        for (MarketingStrategyModifyAdjustBudget adjustBudget : adjustBudgets) {
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){{
                this.setBusinessCode(adjustBudget.getModifyBusinessCode());
                this.setMonthBudgetCode(adjustBudget.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.ADJUST_IN.getCode());
                this.setOperationAmount(adjustBudget.getAdjustAmount());
            }};
            budgetOperateList.add(operateMonthBudgetDto);
        }
        monthBudgetService.operateBudget(budgetOperateList);
    }

    public void passReturnMonthBudgetByModifyCode(List<MarketingStrategyItemModify> modifyItemList,List<MarketingStrategyBudgetModifyDto> modifyItemBudgetList) {
        List<String> itemCodeList = modifyItemList.stream().map(MarketingStrategyItemModify::getStrategyItemCode).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyItemCodeList(itemCodeList);
        List<MarketingStrategyBudgetDto> originBudgetList = marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        //这里只查需要退回的数据，及变前后比变更后多的金额
        Map<String, BigDecimal> modifyBudgetMap = modifyItemBudgetList.stream().collect(Collectors.toMap(item -> {
            return item.getStrategyItemCode() + item.getMonthBudgetCode();
        }, MarketingStrategyBudgetModifyDto::getUseAmount));

        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        for (MarketingStrategyBudgetDto budgetShare : originBudgetList) {
            if (null == budgetShare.getUseAmount() || budgetShare.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            BigDecimal modifyUseAmount = modifyBudgetMap.getOrDefault(budgetShare.getStrategyItemCode() + budgetShare.getMonthBudgetCode(), BigDecimal.ZERO);
            if (budgetShare.getUseAmount().compareTo(modifyUseAmount) <= 0){
                //不变或者是变多了，提交的时候扣过了
                continue;
            }
            OperateMonthBudgetDto operateMonthBudgetDto = new OperateMonthBudgetDto(){{
                this.setBusinessCode(budgetShare.getStrategyItemCode());
                this.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(budgetShare.getUseAmount().subtract(modifyUseAmount));
            }};
            budgetOperateList.add(operateMonthBudgetDto);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudgetStrategy(budgetOperateList);
        }

    }

    
    
    
}
