package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyBudgetModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModify;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.entity.MarketingStrategyModifyAdjustBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyModifyAdjustBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.service.MarketingStrategyModifyAdjustBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyModifyAdjustBudgetDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2022/12/6 09:39
 */
@Service
public class MarketingStrategyModifyAdjustBudgetServiceImpl implements MarketingStrategyModifyAdjustBudgetService {

    @Autowired(required = false)
    private MarketingStrategyModifyAdjustBudgetRepository marketingStrategyModifyAdjustBudgetRepository;


    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void saveMarketingStrategyBudgetList(MarketingStrategyModify entity, boolean update, List<MarketingStrategyModifyAdjustBudgetDto> adjustBudgetList) {
        //        Map<String, MarketingStrategyBudgetModifyDto> oldMap = Maps.newHashMap();
        if (update){
//            List<MarketingStrategyBudgetModifyDto> oldDtoList = marketingStrategyBudgetModifyRepository.listByModifyBusinessCode(entity.getModifyBusinessCode());
//            oldMap = oldDtoList.stream().collect(Collectors.toMap(item -> {
//                return item.getStrategyItemCode() + item.getMonthBudgetCode() ;
//            }, Function.identity()));
            marketingStrategyModifyAdjustBudgetRepository.deleteByModifyBusinessCodes(Lists.newArrayList(entity.getModifyBusinessCode()));
        }
        if (CollectionUtils.isEmpty(adjustBudgetList)){
            return;
        }

        List<MarketingStrategyModifyAdjustBudget> list = Lists.newArrayList();
        for (MarketingStrategyModifyAdjustBudgetDto adjustBudgetDto : adjustBudgetList) {
            MarketingStrategyModifyAdjustBudget marketingStrategyModifyAdjustBudget = nebulaToolkitService.copyObjectByWhiteList(adjustBudgetDto, MarketingStrategyModifyAdjustBudget.class, HashSet.class, ArrayList.class);
            list.add(marketingStrategyModifyAdjustBudget);
        }


        List<MarketingStrategyModifyAdjustBudget> saveList = Lists.newArrayList();
        for (MarketingStrategyModifyAdjustBudget item : list) {
//            String key = item.getStrategyItemCode() + item.getMonthBudgetCode();
//            if (oldMap.containsKey(key)){
//                item.setId(oldMap.get(key).getId());
//                updateList.add(item);
//                oldMap.remove(key);
//            }else{
            item.setModifyBusinessCode(entity.getModifyBusinessCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
//            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            marketingStrategyModifyAdjustBudgetRepository.saveBatch(saveList);
        }
    }

}
