package com.biz.crm.tpm.business.marketing.strategy.local.modify.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyBudgetModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.modify.repository.MarketingStrategyItemModifyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyItemModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo.MarketingStrategyItemModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 营销策略明细变更分页缓存处理
 * @author wanghaojia
 * @date 2022/12/16 15:25
 */
@Component
public class MarketingStrategyModifyPageCacheHelper extends MnPageCacheHelper<MarketingStrategyItemModifyVo, MarketingStrategyItemModifyDto> {

    @Autowired(required = false)
    private MarketingStrategyItemModifyRepository marketingStrategyItemModifyRepository;
    @Autowired(required = false)
    private MarketingStrategyBudgetModifyRepository marketingStrategyBudgetModifyRepository;

    @Autowired(required = false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return MarketingStrategyConstant.MARKETING_STRATEGY_ITEM_MODIFY_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<MarketingStrategyItemModifyDto> getDtoClass() {
        return MarketingStrategyItemModifyDto.class;
    }

    @Override
    public Class<MarketingStrategyItemModifyVo> getVoClass() {
        return MarketingStrategyItemModifyVo.class;
    }

    @Override
    public List<MarketingStrategyItemModifyDto> findDtoListFromRepository(MarketingStrategyItemModifyDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getModifyBusinessCode())){
            return Lists.newArrayList();
        }

        //有策略编码，从数据库里面查出来放到缓存里面
        List<MarketingStrategyItemModifyDto> modifyItemList = marketingStrategyItemModifyRepository.findDtoAndAttachList(dto);
        if (CollectionUtil.isEmpty(modifyItemList)){
            return Lists.newArrayList();
        }
        marketingStrategyItemModifyRepository.fillDtoListProperties(modifyItemList);
        return modifyItemList;
    }

    @Override
    public List<MarketingStrategyItemModifyDto> newItem(String cacheKey, List<MarketingStrategyItemModifyDto> itemList) {
        MarketingStrategyItemModifyDto newItem = new MarketingStrategyItemModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList(newItem);
    }

    @Override
    public List<MarketingStrategyItemModifyDto> copyItem(String cacheKey, List<MarketingStrategyItemModifyDto> itemList) {
        List<MarketingStrategyItemModifyDto> newItemList = (List<MarketingStrategyItemModifyDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, MarketingStrategyItemModifyDto.class, MarketingStrategyItemModifyDto.class, HashSet.class, ArrayList.class);
        for (MarketingStrategyItemModifyDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setStrategyItemCode(null);
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(MarketingStrategyItemModifyDto MarketingStrategyItemModifyDto) {
        return MarketingStrategyItemModifyDto.getId();
    }

    @Override
    public String getCheckedStatus(MarketingStrategyItemModifyDto MarketingStrategyItemModifyDto) {
        return MarketingStrategyItemModifyDto.getChecked();
    }
}
