package com.biz.crm.tpm.business.marketing.strategy.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyQueryActivityPlanDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.event.MarketingStrategyQueryActivityPlanListener;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyQueryActivityPlanResponse;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * 营销策略(MarketingStrategy)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-05 16:06:03
 */
@Component
public class MarketingStrategyDataViewRegister implements MnDataviewRegister {

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;

    @Autowired(required = false)
    @Qualifier("inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Override
    public String code() {
        return "tpm_marketing_strategy_data_view";
    }

    @Override
    public String desc() {
        return "TPM-营销策略";
    }

    @Override
    public String buildSql() {
        return "select\n" +
                "a.*,'' as parent_department_name,\n" +
                "'' as strategy_item_code,\n" +
                "'' as strategy_relate_plan_code\n" +
                " from tpm_marketing_strategy a\n" +
                "where a.tenant_code = :tenantCode\n" +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }

    @Override
    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)){
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if (MarketingStrategyExecuteParameterBuildInterceptor.parent_department_name.equals(databaseExecuteParameter.getTargetFieldName())){
            return parentDepartmentNameQuery(databaseExecuteParameter,valueStr);
        }else if (MarketingStrategyExecuteParameterBuildInterceptor.strategy_item_code.equals(databaseExecuteParameter.getTargetFieldName())){
            return strategyItemCodeQuery(databaseExecuteParameter,valueStr);
        }else if (MarketingStrategyExecuteParameterBuildInterceptor.strategy_relate_plan_code.equals(databaseExecuteParameter.getTargetFieldName())){
            return strategyRelatePlanCodeQuery(databaseExecuteParameter,valueStr);
        }
        return valueStr;
    }

    private Object parentDepartmentNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr){
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "attr_org_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        List<String> orgCodeList = Lists.newArrayList("_");
        //上级组织查询
        OrgQueryDto orgQueryDto = new OrgQueryDto();
        orgQueryDto.setOrgName(valueStr);
        Set<String> parentCodeSet = orgVoService.findByOrgQueryDto(orgQueryDto);
        if (CollectionUtils.isEmpty(parentCodeSet)){
            return orgCodeList;
        }
        orgQueryDto.setOrgName(null);
        List<String> parentOrgCodeList = Lists.newArrayList(parentCodeSet);
        orgQueryDto.setParentOrgCodeList(parentOrgCodeList);
        Set<String> codeSet = orgVoService.findByOrgQueryDto(orgQueryDto);
        orgCodeList.addAll(codeSet);
        return orgCodeList;
    }

    private Object strategyItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr){
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "strategy_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        //根据策略明细编码查询策略编码
        List<String> strategyCodeList = Lists.newArrayList("_");
        strategyCodeList.addAll(marketingStrategyItemRepository.findStrategyCodeListByItemCodeList(Arrays.asList(valueStr.split("[, ，]"))));
        return strategyCodeList;
    }

    private Object strategyRelatePlanCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr){
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "strategy_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        //根据策略明细编码查询策略编码
        List<String> strategyCodeList = Lists.newArrayList("_");
        MarketingStrategyQueryActivityPlanDto queryActivityPlanDto = new MarketingStrategyQueryActivityPlanDto();
        List<String> planCodeList = Arrays.asList(valueStr.split("[, ，]"));
        queryActivityPlanDto.setPlanCodeList(planCodeList);
        SerializableBiConsumer<MarketingStrategyQueryActivityPlanListener, MarketingStrategyQueryActivityPlanDto> queryActivityPlan =
                MarketingStrategyQueryActivityPlanListener::strategyRelatePlanCodeList;
        MarketingStrategyQueryActivityPlanResponse queryActivityPlanResponse = (MarketingStrategyQueryActivityPlanResponse) this.nebulaNetEventClient.directPublish(queryActivityPlanDto,
                MarketingStrategyQueryActivityPlanListener.class, queryActivityPlan);
        if (!CollectionUtils.isEmpty(queryActivityPlanResponse.getStrategyCodeList())){
            strategyCodeList.addAll(queryActivityPlanResponse.getStrategyCodeList());
        }
        return strategyCodeList;
    }

}
