package com.biz.crm.tpm.business.marketing.strategy.local.register;

import com.bizunited.nebula.europa.database.local.service.bind.MnCustomParamFieldBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.service.ExecuteParameterBuildInterceptor;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 活动方案(ActivityPlan)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class MarketingStrategyExecuteParameterBuildInterceptor implements ExecuteParameterBuildInterceptor {

    /**
     * 上级组织查询
     */
    public static final String parent_department_name = "parent_department_name";
    /**
     * 策略明细编码
     */
    public static final String strategy_item_code = "strategy_item_code";

    /**
     * 策略关联活动方案编码
     */
    public static final String strategy_relate_plan_code = "strategy_relate_plan_code";

    @Autowired(required = false)
    private MnCustomParamFieldBindingStrategy mnCustomParamFieldBindingStrategy;

    @Autowired(required = false)
    private MarketingStrategyDataViewRegister register;

    @Override
    public void onBuildExecuteParameters(MetaData metaData, EuropaInfoVo europaInfoVo, Set<ExecuteParameter> set) {
        DatabaseViewVo view = (DatabaseViewVo)europaInfoVo.getView();
        String dataviewCode = view.getRegisterCode();
        if (!StringUtils.equals(register.code(), dataviewCode)) {
            return;
        }
        for (ExecuteParameter executeParameter : set) {
            if (executeParameter instanceof DatabaseExecuteParameter){
                DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
                if (parent_department_name.equals(databaseExecuteParameter.getTargetFieldName())){
                    //上级组织查询
                    databaseExecuteParameter.setValueBindType(MnCustomParamFieldBindingStrategy.PARAM_BIND_TYPE);
                    mnCustomParamFieldBindingStrategy.setEuropaInfoVo(europaInfoVo);
                }else if (strategy_item_code.equals(databaseExecuteParameter.getTargetFieldName())){
                    //策略明细编码查询
                    databaseExecuteParameter.setValueBindType(MnCustomParamFieldBindingStrategy.PARAM_BIND_TYPE);
                    mnCustomParamFieldBindingStrategy.setEuropaInfoVo(europaInfoVo);
                }else if (strategy_relate_plan_code.equals(databaseExecuteParameter.getTargetFieldName())){
                    //策略关联活动方案编码查询
                    databaseExecuteParameter.setValueBindType(MnCustomParamFieldBindingStrategy.PARAM_BIND_TYPE);
                    mnCustomParamFieldBindingStrategy.setEuropaInfoVo(europaInfoVo);
                }
            }
        }
    }

}
