package com.biz.crm.tpm.business.marketing.strategy.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 营销策略预算
 * @author wanghaojia
 * @date 2023/1/10 20:37
 */
public interface MarketingStrategyBudgetService {

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<MarketingStrategyBudgetVo> findByConditions(Pageable pageable, MarketingStrategyBudgetDto dto);

    /**
     * 保存月度预算
     */
    void saveMarketingStrategyBudgetList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemDtoList);

    /**
     * 扣减月度预算
     */
    void useMonthBudgetByCodeList(List<String> codeList);

    void useMonthBudgetByCodeList(List<String> codeList, boolean doSave);

    /**
     * 退回月度预算
     */
    void returnMonthBudgetByCodeList(List<String> codeList);


    void useMonthBudget(List<MarketingStrategyBudgetDto> budgetList, boolean doSave);

    /**
     * 同时删除预算
     */
    void deleteByStrategyCodes(List<String> strategyCodes);

    void returnMonthBudget(List<MarketingStrategyBudgetDto> budgetList);
}
