package com.biz.crm.tpm.business.marketing.strategy.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemScope;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyContentExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.List;

/**
 * 营销策略(MarketingStrategy)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:06
 */
public interface MarketingStrategyItemService extends MnPageCacheService<MarketingStrategyItemVo,MarketingStrategyItemDto> {

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto);

    /**
     * 获取预算汇总信息
     * @param cacheKey 缓存key
     * @return
     */
    List<MarketingStrategyBudgetSumVo> findMarketingStrategyBudgetCacheSumList(String businessUnitCode,String cacheKey);

    /**
     * 保存营销策略明细数据-默认走校验逻辑
     * @param itemCacheList 营销策略明细数据
     */
    void saveMarketingStrategyItemList(MarketingStrategy entity,boolean update,List<MarketingStrategyItemDto> itemCacheList);

    /**
     * 保存营销策略明细数据
     * @param itemCacheList 营销策略明细数据
     * @param createValidate 是否走校验逻辑
     */
    void saveMarketingStrategyItemList(MarketingStrategy entity,boolean update,List<MarketingStrategyItemDto> itemCacheList, boolean createValidate,boolean tempSave);

    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dto 营销策略明细数据
     */
    void createValidateList(MarketingStrategyDto dto,List<MarketingStrategyItemDto> dtoList);

    /**
     * 营销策略明细新增校验逻辑
     * @param dto 营销策略明细数据
     */
    void createValidate(MarketingStrategyItemDto dto);

    /**
     * 活动类型下拉
     * @param dto 活动类型查询参数
     */
    List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto);

    /**
     * 活动形式下拉
     * @param dto 活动形式查询参数
     * @return 活动形式下拉数据
     */
    List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto);

    /**
     * 获取分摊到范围上的信息
     */
    List<MarketingStrategyItemScope> findShareScopeList(MarketingStrategyItemDto dto);

    /**
     * 获取总条数
     *
     * @param cacheKey
     * @return
     */
    Integer getTotal(String cacheKey);

    void tempSaveCreateValidateList(MarketingStrategyDto dto, List<MarketingStrategyItemDto> itemCacheList);

    List<MarketingStrategyItemVo> findByCodes(List<String> itemCodes);

    /**
     * 主列表明细导出获取总条数
     * @param marketingStrategyItemDto
     * @return
     */
    Integer itemExportGetTotal(MarketingStrategyItemDto marketingStrategyItemDto);

    /**
     * 主列表明细导出分页获取数据
     * @param pageable
     * @param marketingStrategyItemDto
     * @return
     */
    Page<MarketStrategyItemExportVo> itemExportGetDate(Pageable pageable, MarketingStrategyItemDto marketingStrategyItemDto);

    void closeMarketingStrategyItem(List<String> ids);

}

