package com.biz.crm.tpm.business.marketing.strategy.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.local.dto.MarketingStrategyApproveDto;
import com.biz.crm.tpm.business.marketing.strategy.local.dto.MarketingStrategyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveInfoVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveProcessInfoVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 营销策略(MarketingStrategy)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-05 16:06:03
 */
public interface MarketingStrategyService{

    /**
     * 策略保存新增方法
     * @param dto 单策略表头数据
     * @param itemCacheKey 明细缓存key
     */
    void saveSingleMarketingStrategy(MarketingStrategyDto dto,String itemCacheKey);

    /**
     * 多策略保存新增方法
     * @param itemCacheList 多策略行明细
     */
    void saveMutiMarketingStrategy(MarketingStrategyDto dto,List<MarketingStrategyItemDto> itemCacheList);

    /**
     * 查询可以选择的月度预算
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    Page<MonthBudgetVo> findMonthBudgetByConditions(Pageable pageable, MonthBudgetDto dto);

    /**
     * 查询可以选择的年度预算
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    Page<YearBudgetVo> findYearBudgetByConditions(Pageable pageable, YearBudgetDto dto);

    /**
     * 删除策略
     * @param ids 策略ids
     */
    void deleteMarketingStrategy(List<String> ids);

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<MarketingStrategyVo> findByConditions(Pageable pageable, MarketingStrategyDto dto);

    /**
     * 通过id获取营销策略数据
     */
    MarketingStrategyVo findById(String id);

    /**
     * 获取流程审批信息,根据查询条件
     */
    List<MarketingStrategyApproveInfoVo> findApproveInfoList(MarketingStrategyApproveDto dto);

    /**
     * 获取流程审批信息
     */
    List<MarketingStrategyApproveInfoVo> findApproveInfoList(List<String> strategyCodeList);


    /**
     * 获取待审批的营销策略数据
     * @param dto 查询条件
     * @return 待审批的营销策略数据
     */
    List<String> findToApprovalCodeList(MarketingStrategyApproveDto dto);

    /**
     * 更新流程状态
     * @param codeList 要更新的编码
     * @param processStatus 流程状态
     */
    void updateProcessStatus(List<String> codeList, String processStatus);

    /**
     * 提交流程
     * @param toApprovalCodeList 待提交的编码
     */
    void submitApproval(List<String> toApprovalCodeList, MarketingStrategyApproveSubmitDto dto);

    /**
     * 营销策略审批通过
     */
    void processPass(ProcessStatusDto dto);

    /**
     * 审批驳回|流程追回
     */
    void processRejectAndRecover(ProcessStatusDto dto);

    /**
     * 根据流程编码获取营销策略审批数据
     * @param processNo 流程编码
     */
    MarketingStrategyApproveProcessInfoVo findApproveProcessInfo(String processNo);

    MarketingStrategyOutDto saveSingleMarketingStrategyNoCache(MarketingStrategyOutDto dto);

    Page<MarketingStrategyItemVo> findApproveProcessItemPage(Pageable pageable, MarketingStrategyApproveDto dto);

    /**
     * 策略审批中分页查询策略明细接口
     */
    Page<MarketingStrategyItemVo> findApproveProcessItemPage(Pageable pageable, MarketingStrategyDto dto);

    List<MarketingStrategyBudgetSumVo> findApproveProcessSumInfo(String processNo);

}

