package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyLockSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.OperateYearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 活动细案预算
 * @author wanghaojia
 * @date 2023/1/10 20:37
 */
@Service
public class MarketingStrategyBudgetServiceImpl implements MarketingStrategyBudgetService {


    @Autowired(required = false)
    private MarketingStrategyBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private MarketingStrategyRepository marketingStrategyRepository;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MarketingStrategyLockSdkService marketingStrategyLockSdkService;

    @Override
    public Page<MarketingStrategyBudgetVo> findByConditions(Pageable pageable, MarketingStrategyBudgetDto dto) {
        return activityDetailPlanBudgetRepository.findByConditions(pageable,dto);
    }

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param itemDtoList  活动方案关联预算数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveMarketingStrategyBudgetList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemDtoList) {
        Map<String, MarketingStrategyBudgetDto> oldMap = Maps.newHashMap();
        if (update){
            activityDetailPlanBudgetRepository.deletePhysicalByStrategyCode(entity.getStrategyCode());
        }

        List<MarketingStrategyBudget> list = Lists.newArrayList();
        for (MarketingStrategyItemDto itemDto : itemDtoList) {
            List<MarketingStrategyBudget> budgetList = Lists.newArrayList();
            List<MarketingStrategyBudgetDto> budgetShares = itemDto.getBudgetShares();
            if (!CollectionUtils.isEmpty(budgetShares)){
                Collection<MarketingStrategyBudget> budgetShareEntityList = nebulaToolkitService.copyCollectionByWhiteList(budgetShares, MarketingStrategyBudgetDto.class, MarketingStrategyBudget.class, HashSet.class, ArrayList.class);
                for (MarketingStrategyBudget monthBudget : budgetShareEntityList) {
                    monthBudget.setStrategyCode(itemDto.getStrategyCode());
                    monthBudget.setStrategyItemCode(itemDto.getStrategyItemCode());
                }
                budgetList.addAll(budgetShareEntityList);
            }
            list.addAll(budgetList);
        }


        List<MarketingStrategyBudget> saveList = Lists.newArrayList();
        List<MarketingStrategyBudget> updateList = Lists.newArrayList();
        for (MarketingStrategyBudget item : list) {
            item.setStrategyCode(entity.getStrategyCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityDetailPlanBudgetRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityDetailPlanBudgetRepository.updateBatchById(updateList);
        }

    }

    /**
     * 扣减月度预算
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useMonthBudgetByCodeList(List<String> codeList){
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        useMonthBudgetByCodeList(codeList, true);

    }

    /**
     * 扣减月度预算
     * @param codeList 扣减的预算编码，为false的话只做验证
     * @param doSave 是否保存
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useMonthBudgetByCodeList(List<String> codeList, boolean doSave){
        List<MarketingStrategyBudget> budgets = activityDetailPlanBudgetRepository.listByStrategyCodeList(codeList);
        if (CollectionUtils.isEmpty(budgets)){
            return;
        }
        List<MarketingStrategyBudgetDto> budgetDtos = (List<MarketingStrategyBudgetDto>) nebulaToolkitService.copyCollectionByBlankList(budgets, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class);
        MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
        marketingStrategyDto.setStrategyCodeList(codeList);
        List<MarketingStrategy> strategyList = marketingStrategyRepository.findList(marketingStrategyDto);
        //一次操作只会有一个业务单元，直接取第一条吧
        String businessUnitCode = strategyList.get(0).getBusinessUnitCode();
        for (MarketingStrategyBudgetDto budgetDto : budgetDtos) {
            budgetDto.setBusinessUnitCode(businessUnitCode);
        }
        useMonthBudget(budgetDtos,doSave);
    }

    /**
     * 扣减月度预算
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useMonthBudget(List<MarketingStrategyBudgetDto> budgetList,boolean doSave){
        if (CollectionUtils.isEmpty(budgetList)){
            return;
        }
        String businessUnitCode = budgetList.get(0).getBusinessUnitCode();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)){
            List<OperateMonthBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
                //扣减类型为占用预算的
                return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0;
            }).map(item -> new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getStrategyItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(item.getUseAmount());
                this.setDoSave(doSave);
            }}).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)){
                monthBudgetService.operateBudgetStrategy(planBudgetOperateList);
            }
        }else{
            List<OperateYearBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
                //扣减类型为占用预算的
                return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0;
            }).map(item -> new OperateYearBudgetDto(){{
                this.setBusinessCode(item.getStrategyItemCode());
                this.setYearBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(item.getUseAmount());
                this.setDoSave(doSave);
            }}).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)){
                //垂直扣减年度预算
                yearBudgetSdkService.operateBudgetStrategy(planBudgetOperateList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByStrategyCodes(List<String> strategyCodes) {
        activityDetailPlanBudgetRepository.deleteByStrategyCodes(strategyCodes);
    }

    /**
     * 退回月度预算
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void returnMonthBudgetByCodeList(List<String> codeList){
        if (CollectionUtil.isEmpty(codeList)) {
            return;
        }
        boolean lockSuccess = marketingStrategyLockSdkService.lock(codeList, TimeUnit.MINUTES, 3);
        Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
        try {
            List<MarketingStrategyBudget> budgetList = activityDetailPlanBudgetRepository.listByStrategyCodeList(codeList);
            if (!CollectionUtils.isEmpty(budgetList)){
                List<MarketingStrategyBudgetDto> budgetDtos = (List<MarketingStrategyBudgetDto>) nebulaToolkitService.copyCollectionByBlankList(budgetList, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class);
                //一次操作应该就只有一个业务单元，查个业务单元放进去吧
                MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
                marketingStrategyDto.setStrategyCode(codeList.get(0));
                List<MarketingStrategy> strategyList = marketingStrategyRepository.findList(marketingStrategyDto);
                budgetDtos.get(0).setBusinessUnitCode(strategyList.get(0).getBusinessUnitCode());
                returnMonthBudget(budgetDtos);
            }
        } finally {
            marketingStrategyLockSdkService.unlock(codeList);
        }
    }

    /**
     * 扣减月度预算
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void returnMonthBudget(List<MarketingStrategyBudgetDto> budgetList){
        if (CollectionUtils.isEmpty(budgetList)){
            return;
        }
        String businessUnitCode = budgetList.get(0).getBusinessUnitCode();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)){
            List<OperateMonthBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
                //扣减类型为占用预算的
                return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0;
            }).map(item -> new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getStrategyItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }}).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)){
                monthBudgetService.operateBudgetStrategy(planBudgetOperateList);
            }
        }else{
            List<OperateYearBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
                //扣减类型为占用预算的
                return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0;
            }).map(item -> new OperateYearBudgetDto(){{
                this.setBusinessCode(item.getStrategyItemCode());
                this.setYearBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }}).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planBudgetOperateList)){
                //垂直扣减年度预算
                yearBudgetSdkService.operateBudgetStrategy(planBudgetOperateList);
            }
        }

    }


}
