package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyItemSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/3/15 15:49
 */
@Service
public class MarketingStrategyItemSdkServiceImpl implements MarketingStrategyItemSdkService {

    @Autowired(required = false)
    private MarketingStrategyItemService marketingStrategyItemService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Override
    public Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto) {
        if (!StringUtils.isEmpty(dto.getAttrOrgCode())){
            List<String> attrOrgCodeList = Arrays.asList(dto.getAttrOrgCode().split(","));
            List<OrgVo> childOrgList = orgVoService.findAllChildrenByOrgCodes(attrOrgCodeList);
            if (!CollectionUtils.isEmpty(childOrgList)){
                dto.setAttrOrgCodeList(childOrgList.stream().map(OrgVo::getOrgCode).collect(Collectors.toList()));
            }else{
                dto.setAttrOrgCodeList(attrOrgCodeList);
            }
        }
        return marketingStrategyItemService.findByConditions(pageable, dto);
    }


    @Override
    public List<MarketingStrategyItemVo> findByItemCodes(List<String> itemCodes) {
        return this.marketingStrategyItemService.findByCodes(itemCodes);
    }
}
