package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.constant.MnPageCacheConstant;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyBudget;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyConstant;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyQueryActivityPlanDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.MarketingStrategyBudgetShareRuleEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.event.MarketingStrategyQueryActivityPlanListener;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemScope;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketStrategyItemExportVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyQueryActivityPlanResponse;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.StrategyActivityPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 营销策略(MarketingStrategy)表服务实现类
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:11
 */
@Service("marketingStrategyItemService")
public class MarketingStrategyItemServiceImpl extends MnPageCacheServiceImpl<MarketingStrategyItemVo, MarketingStrategyItemDto> implements MarketingStrategyItemService {

    @Autowired(required = false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;

    @Autowired(required = false)
    private MarketingStrategyRepository marketingStrategyRepository;

    @Autowired(required = false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;

    @Autowired(required = false)
    private MarketingStrategyBudgetService marketingStrategyBudgetService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 生成编码服务
     */
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 活动类型服务
     */
    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    /**
     * 活动形式服务长
     */
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    /**
     * 年度预算服务
     */
    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    /**
     * 销量任务服务
     */
    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    /**
     * 销量任务服务
     */
    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    /**
     * 按条件查询营销策略
     *
     * @param pageable 分页参数
     * @param dto      查询参数
     */
    @Override
    public Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto) {
        return marketingStrategyItemRepository.findByConditions(pageable, dto);
    }


    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @Override
    public List<MarketingStrategyBudgetSumVo> findMarketingStrategyBudgetCacheSumList(String businessUnitCode,String cacheKey) {
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            return findVerticalMarketingStrategyBudgetCacheSumList(businessUnitCode,cacheKey);
        }
        List<MarketingStrategyItemDto> itemList = findCacheList(cacheKey);
        Map<String, MarketingStrategyBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (MarketingStrategyItemDto item : itemList) {
            if (StringUtils.isEmpty(item.getMonthBudgetCode())) {
                continue;
            }
                //预算不为空才处理
                MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), (key) -> new MarketingStrategyBudgetSumVo() {{
                    this.setTotalStrategyAmount(BigDecimal.ZERO);
                    this.setInitResolveAmount(BigDecimal.ZERO);
                    this.setUsedStrategyAmount(BigDecimal.ZERO);
                    this.setCanApplyStrategyAmount(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetSumVo.setBudgetItemName(item.getBudgetItemName());
                if (StringUtils.isNotEmpty(item.getFeeAmountStr())) {
                    try {
                        budgetSumVo.setTotalStrategyAmount(budgetSumVo.getTotalStrategyAmount().add(new BigDecimal(item.getFeeAmountStr())));
                    } catch (Exception ignore) {
                    }
                }
                feeBudgetCodeSet.add(item.getMonthBudgetCode());
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            for (MonthBudgetVo budgetVo : budgetVos) {
                MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                if (null != budgetVo.getInitResolveAmount()) {
                    budgetSumVo.setInitResolveAmount(budgetVo.getInitResolveAmount());
                }
                if (null != budgetVo.getMonthRollingAmount()) {
                    budgetSumVo.setMonthRollingAmount(budgetVo.getMonthRollingAmount());
                }
                if (null != budgetVo.getLastMonthRollingAmount()) {
                    budgetSumVo.setLastMonthRollingAmount(budgetVo.getLastMonthRollingAmount());
                }
                if (null != budgetVo.getAfterFreezeAmount()) {
                    budgetSumVo.setAfterFreezeAmount(budgetVo.getAfterFreezeAmount());
                }
                if (null != budgetVo.getUsedStrategyAmount()) {
                    budgetSumVo.setUsedStrategyAmount(budgetVo.getUsedStrategyAmount());
                }
            }
        }
        List<MarketingStrategyBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        budgetSumList.forEach(item -> {
            item.setCanApplyStrategyAmount(item.getAfterFreezeAmount().subtract(item.getUsedStrategyAmount()));
        });

        return budgetSumList;
    }


    /**
     * 获取预算汇总信息-垂直
     */
    public List<MarketingStrategyBudgetSumVo> findVerticalMarketingStrategyBudgetCacheSumList(String businessUnitCode,String cacheKey) {

        List<MarketingStrategyItemDto> itemList = findCacheList(cacheKey);
        Map<String, MarketingStrategyBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (MarketingStrategyItemDto item : itemList) {
            List<MarketingStrategyBudgetDto> budgetShares = item.getBudgetShares();
            if (CollectionUtils.isEmpty(budgetShares)){
                continue;
            }
            for (MarketingStrategyBudgetDto budgetShare : budgetShares) {
                if (StringUtils.isBlank(budgetShare.getMonthBudgetCode())) {
                    continue;
                }
                //预算不为空才处理
                MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(budgetShare.getMonthBudgetCode(), (key) -> new MarketingStrategyBudgetSumVo() {{
                    this.setTotalStrategyAmount(BigDecimal.ZERO);
                    this.setInitResolveAmount(BigDecimal.ZERO);
                    this.setUsedStrategyAmount(BigDecimal.ZERO);
                    this.setCanApplyStrategyAmount(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                budgetSumVo.setBudgetItemName(budgetShare.getBudgetItemName());
                if (StringUtils.isNotEmpty(budgetShare.getUseAmountStr())) {
                    try {
                        budgetSumVo.setTotalStrategyAmount(budgetSumVo.getTotalStrategyAmount().add(new BigDecimal(budgetShare.getUseAmountStr())));
                    } catch (Exception ignore) {
                    }
                }
                feeBudgetCodeSet.add(budgetShare.getMonthBudgetCode());
            }
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<YearBudgetVo> budgetVos = yearBudgetSdkService.findByYearBudgetCodes(feeBudgetCodeList);
            for (YearBudgetVo budgetVo : budgetVos) {
                MarketingStrategyBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getYearBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                if (null != budgetVo.getBudgetTotalAmount()) {
                    budgetSumVo.setAfterFreezeAmount(budgetVo.getBudgetTotalAmount());
                }
                if (null != budgetVo.getUsedStrategyAmount()) {
                    budgetSumVo.setUsedStrategyAmount(budgetVo.getUsedStrategyAmount());
                }
            }
        }
        List<MarketingStrategyBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        budgetSumList.forEach(item -> {
            item.setCanApplyStrategyAmount(item.getAfterFreezeAmount().subtract(item.getUsedStrategyAmount()));
        });

        return budgetSumList;
    }

    /**
     * 保存营销策略明细数据-默认走校验逻辑
     *
     * @param itemCacheList 营销策略明细数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveMarketingStrategyItemList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemCacheList) {
        saveMarketingStrategyItemList(entity, update, itemCacheList, true,false);
    }

    /**
     * 保存营销策略明细数据
     *
     * @param itemCacheList  营销策略明细数据
     * @param createValidate 是否走校验逻辑
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveMarketingStrategyItemList(MarketingStrategy entity, boolean update, List<MarketingStrategyItemDto> itemCacheList, boolean createValidate,boolean tempSave) {
        if (createValidate && !tempSave) {
            MarketingStrategyDto dto = nebulaToolkitService.copyObjectByWhiteList(entity,MarketingStrategyDto.class,HashSet.class,ArrayList.class);
            this.createValidateList(dto,itemCacheList);
        }else if (tempSave) {
            MarketingStrategyDto dto = nebulaToolkitService.copyObjectByWhiteList(entity,MarketingStrategyDto.class,HashSet.class,ArrayList.class);
            this.tempSaveCreateValidateList(dto,itemCacheList);
        }
        Map<String, MarketingStrategyItem> oldMap = Maps.newHashMap();
        if (update) {
            List<MarketingStrategyItem> oldList = marketingStrategyItemRepository.findListByStrategyCode(entity.getStrategyCode());
            oldMap = oldList.stream().collect(Collectors.toMap(MarketingStrategyItem::getId, Function.identity()));
        }
        List<MarketingStrategyItem> saveList = Lists.newArrayList();
        List<MarketingStrategyItem> updateList = Lists.newArrayList();
        Map<String, MarketingStrategyItemDto> dtoMap = Maps.newHashMap();
        for (MarketingStrategyItemDto item : itemCacheList) {
            dtoMap.put(item.getId(), item);
            item.setStrategyCode(entity.getStrategyCode());
            if (oldMap.containsKey(item.getId())) {
                MarketingStrategyItem oldItemEntity = oldMap.get(item.getId());
                item.setStrategyItemCode(oldItemEntity.getStrategyItemCode());
                MarketingStrategyItem itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, MarketingStrategyItem.class, HashSet.class, ArrayList.class);
                updateList.add(itemEntity);
                oldMap.remove(item.getId());
            } else {
                MarketingStrategyItem itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, MarketingStrategyItem.class, HashSet.class, ArrayList.class);
                saveList.add(itemEntity);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
            String yyyyMMdd = DateFormatUtils.format(new Date(), "yyyyMMdd");
//            String ruleCode = StringUtils.join(MarketingStrategyConstant.MARKETING_STRATEGY_ITEM_RULE_CODE_PRE, yyyyMMdd);
            List<String> codeList = this.generateCodeService.generateCode(MarketingStrategyConstant.MARKETING_STRATEGY_ITEM_RULE_CODE_PRE, saveList.size(), 6, 2, TimeUnit.DAYS);
            Iterator<String> codeIterator = codeList.iterator();
            for (MarketingStrategyItem item : saveList) {
                item.setStrategyItemCode(codeIterator.next());
                MarketingStrategyItemDto dto = dtoMap.get(item.getId());
                dto.setStrategyItemCode(item.getStrategyItemCode());
                item.setStrategyCode(entity.getStrategyCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
            }
            marketingStrategyItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            marketingStrategyItemRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            //待删除的数据
            marketingStrategyItemRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public List<MarketingStrategyItemDto> findCacheList(String cacheKey) {
        List<MarketingStrategyItemDto> itemList = super.findCacheList(cacheKey);

        List<MarketingStrategyItemDto> newList = Lists.newArrayList();
        for (MarketingStrategyItemDto dto : itemList) {
            //TODO 这里有问题，如果模板上没有配置范围，直接到区域的话数据就没更新，考虑怎么处理
            List<MarketingStrategyItemScope> scopeList = dto.getScopeList();
            if (!CollectionUtils.isEmpty(scopeList)) {
                //有分摊的范围信息，重新处理数据
                dto.setScopeList(null);
                for (int i = 0; i < scopeList.size(); i++) {
                    MarketingStrategyItemScope scopeVo = scopeList.get(i);
                    MarketingStrategyItemDto newDto = nebulaToolkitService.copyObjectByWhiteList(dto, MarketingStrategyItemDto.class, HashSet.class, ArrayList.class);
                    if (i > 0) {
                        //第一条数据保留原始id，后面的置空新增
                        newDto.setId(null);
                    }
                    newDto.setStrategyOrgCode(scopeVo.getScopeCode());
                    newDto.setStrategyOrgName(scopeVo.getScopeName());
                    newDto.setFeeAmountStr(scopeVo.getSureAmount());
                    newDto.setControlRatio(scopeVo.getControlRatio());
                    newDto.setBudgetShares(dto.getBudgetShares());
                    newList.add(newDto);
                }
            } else {
                newList.add(dto);
            }
        }
        return newList;
    }

    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dtoList 营销策略明细数据
     */
    @Override
    public void createValidateList(MarketingStrategyDto dto,List<MarketingStrategyItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        for (MarketingStrategyItemDto item : dtoList) {
            this.createValidate(item);
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, MarketingStrategyItemDto.class, true, null);
        createValidateListHeadQuarters(dto,dtoList);
        createValidateListVertical(dto,dtoList);
    }

    /**
     * 主体策略校验逻辑
     */
    public void createValidateListHeadQuarters(MarketingStrategyDto dto,List<MarketingStrategyItemDto> dtoList){
        //主体跨月逻辑校验
        if (!BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())){
            return;
        }
        List<String> budgetItemCodeList = dtoList.stream().map(MarketingStrategyItemDto::getBudgetItemCode).distinct().collect(Collectors.toList());
        List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(budgetItemCodeList);
        if (CollectionUtils.isEmpty(budgetItemVos)){
            throw new RuntimeException("预算项目查询失败！");
        }
        Map<String, BudgetItemVo> budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        Calendar calendar = Calendar.getInstance();
        for (MarketingStrategyItemDto item : dtoList) {
            DateStringDealUtil.validateDateStrAndSet(item.getBeginDateStr(),"新增时，策略明细开始时间不能为空", true,DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setBeginDate);
            DateStringDealUtil.validateDateStrAndSet(item.getEndDateStr(),"新增时，策略明细结束时间不能为空", true,DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setEndDate);
            Validate.notBlank(item.getBudgetItemCode(),"新增时，策略预算项目不能为空");
            String allowAcrossMonth = BooleanEnum.FALSE.getCapital();//默认不允许跨月
            BudgetItemVo budgetItemVo = budgetItemMap.get(item.getBudgetItemCode());
            if (null == budgetItemVo){
                throw new RuntimeException("预算项目["+item.getBudgetItemCode()+"]有误！");
            }
            if (StringUtils.isNotEmpty(budgetItemVo.getAllowCrossMonth())){
                allowAcrossMonth = budgetItemVo.getAllowCrossMonth();
            }
            if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)){
                continue;
            }
            //此预算项目不允许跨月使用，请修改策略开始时间、策略结束时间！
            int year = Integer.parseInt(item.getStrategyYearMonth().substring(0,4));
            int month = Integer.parseInt(item.getStrategyYearMonth().substring(5))-1;
            calendar.setTime(item.getBeginDate());
            if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)){
                throw new RuntimeException("预算项目["+item.getBudgetItemCode()+"]不允许跨月使用，请修改策略开始时间、策略结束时间！");
            }
            calendar.setTime(item.getEndDate());
            if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)){
                throw new RuntimeException("预算项目["+item.getBudgetItemCode()+"]不允许跨月使用，请修改策略开始时间、策略结束时间！");
            }
        }
    }

    public void createValidateListVertical(MarketingStrategyDto dto,List<MarketingStrategyItemDto> dtoList){
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())){
            return;
        }
//        费效比（费效比=费用投入/销量目标）
        for (MarketingStrategyItemDto itemDto : dtoList) {
//            销量目标   salesGoalAmount
//            费效比      costEffectivenessRatio
            BigDecimal costEffectivenessRatio = BigDecimal.ZERO;
            if (null != itemDto.getSalesGoalAmount() && BigDecimal.ZERO.compareTo(itemDto.getSalesGoalAmount()) != 0){
                costEffectivenessRatio = Optional.ofNullable(itemDto.getFeeAmount()).orElse(BigDecimal.ZERO).divide(itemDto.getSalesGoalAmount(),4, RoundingMode.HALF_UP);
            }
            itemDto.setCostEffectivenessRatio(costEffectivenessRatio);
        }
    }

    @Override
    public void tempSaveCreateValidateList(MarketingStrategyDto dto, List<MarketingStrategyItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        for (MarketingStrategyItemDto item : dtoList) {
            if (!StringUtils.isBlank(item.getStrategySignStr())){
                NumberStringDealUtil.validateNumberStrAndSet(item.getStrategySignStr(), "新增时，策略明细策略标识", true, dto::setStrategySign, Integer.class);
            }
            if (!StringUtils.isBlank(item.getFeeAmountStr())) {
                NumberStringDealUtil.validateNumberStrAndSet(item.getFeeAmountStr(), "新增时，策略明细费用金额", true, dto::setFeeAmount, BigDecimal.class);
            }
        }
        //主体跨月逻辑校验
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())){
            for (MarketingStrategyItemDto item : dtoList) {
                if (!StringUtils.isBlank(item.getBeginDateStr())) {
                    DateStringDealUtil.validateDateStrAndSet(item.getBeginDateStr(),"新增时，策略明细开始时间不能为空", true,DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setBeginDate);
                }
                if (!StringUtils.isBlank(item.getEndDateStr())) {
                    DateStringDealUtil.validateDateStrAndSet(item.getEndDateStr(),"新增时，策略明细结束时间不能为空", true,DateUtil.DEFAULT_YEAR_MONTH_DAY,item::setEndDate);
                }
            }
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, MarketingStrategyItemDto.class, true, null);
    }

    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dto 营销策略明细数据
     */
    @Override
    public void createValidate(MarketingStrategyItemDto dto) {
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        NumberStringDealUtil.validateNumberStrAndSet(dto.getStrategySignStr(), "新增时，策略明细策略标识", true, dto::setStrategySign, Integer.class);
        if (CollectionUtils.isEmpty(dto.getBudgetShares()) && StringUtils.isEmpty(dto.getMonthBudgetCode())) {
            throw new RuntimeException("新增时，策略明细预算不能为空");
        }
        Validate.notBlank(dto.getActivityTypeCode(), "新增时，策略明细活动类型不能为空");
//        Validate.notBlank(dto.getActivityFormCode(), "新增时，策略明细活动形式不能为空");
//        Validate.notBlank(dto.getStrategyOrgCode(), "新增时，策略明细区域不能为空");
        Validate.notBlank(dto.getStrategyYearMonth(), "新增时，策略明细年月不能为空");
//        NumberStringDealUtil.validateNumberStrAndSet(dto.getActivityNumberStr(), "新增时，策略明细活动场次", false, dto::setActivityNumber, Integer.class);
//        NumberStringDealUtil.validateNumberStrAndSet(dto.getQuantityStr(), "新增时，策略明细数量", false, dto::setQuantity, Integer.class);
        NumberStringDealUtil.validateNumberStrAndSet(dto.getFeeAmountStr(), "新增时，策略明细费用金额", true, dto::setFeeAmount, BigDecimal.class);
        dto.setIsClose(BooleanEnum.FALSE.getCapital());
    }

    /**
     * 活动类型下拉
     *
     * @param dto 活动类型查询参数
     */
    @Override
    public List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空！");
        return activityTypeService.findActivityTypeSelectList(dto);
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     */
    @Override
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空！");
//        Validate.notBlank(dto.getActivityTypeCode(), "活动类型不能为空！");
        Validate.isTrue(StringUtils.isNotBlank(dto.getActivityTypeCode()) || StringUtils.isNotBlank(dto.getActivityTypeCodes()), "活动类型不能为空！");
        if (StringUtils.isNotBlank(dto.getActivityTypeCodes())) {
            dto.setActivityTypeCodeList(Arrays.asList(dto.getActivityTypeCodes().split(",")));
        }
        return activityFormService.findActivityFormSelectList(dto);
    }

    /**
     * 获取分摊到范围上的信息
     */
    @Override
    public List<MarketingStrategyItemScope> findShareScopeList(MarketingStrategyItemDto dto) {
        if (StringUtils.isEmpty(dto.getBudgetShareRule())) {
            throw new RuntimeException("请选择分摊规则！");
        }
        if (StringUtils.isEmpty(dto.getFeeAmountStr())) {
            throw new RuntimeException("费用金额不能为空！");
        }
        BigDecimal feeAmount = null;
        try {
            feeAmount = new BigDecimal(dto.getFeeAmountStr());
        } catch (Exception e) {
            throw new RuntimeException("费用金额格式有误！");
        }
        if (StringUtils.isEmpty(dto.getStrategyOrgCode())) {
            throw new RuntimeException("请选择范围！");
        }

        //先组装好数据再赋值
        List<MarketingStrategyItemScope> result = Lists.newArrayList();
        String[] orgCodeArr = dto.getStrategyOrgCode().split(",");
        String[] orgNameArr = new String[0];
        if (StringUtils.isNotEmpty(dto.getStrategyOrgName())) {
            orgNameArr = dto.getStrategyOrgName().split(",");
        }
        for (int i = 0; i < orgCodeArr.length; i++) {
            MarketingStrategyItemScope scopeVo = new MarketingStrategyItemScope();
            scopeVo.setScopeCode(orgCodeArr[i]);
            scopeVo.setScopeName(orgNameArr.length > i ? orgNameArr[i] : null);
            scopeVo.setAdjustAmount("0");
            scopeVo.setSystemShareAmount("0");
            scopeVo.setSureAmount("0");
            result.add(scopeVo);
        }


        BigDecimal leaveAmount = feeAmount;
        if (MarketingStrategyBudgetShareRuleEnum.ONE.getCode().equals(dto.getBudgetShareRule())) {
            //平均分摊
            BigDecimal average = feeAmount.divide(new BigDecimal(orgCodeArr.length), 6, RoundingMode.HALF_DOWN);

            String averageStr = average.toString();
            for (MarketingStrategyItemScope scopeVo : result) {
                scopeVo.setSystemShareAmount(averageStr);
                scopeVo.setSureAmount(averageStr);
                leaveAmount = leaveAmount.subtract(average);
            }
        } else if (MarketingStrategyBudgetShareRuleEnum.TWO.getCode().equals(dto.getBudgetShareRule())) {
            //折后任务量占比分摊
            List<String> regionCodeList = Lists.newArrayList(orgCodeArr);
            SalesGoalDto salesGoalDto = new SalesGoalDto();
            salesGoalDto.setRegionCodeList(regionCodeList);
            salesGoalDto.setProductBrandCode(dto.getProductBrandCode());
            //TODO 产品层级赋值,年月查询条件
            salesGoalDto.setProductCode(dto.getProductCode());
            List<SalesGoalVo> salesGoalList = salesGoalService.findListGroupByRegion(salesGoalDto);
            if (CollectionUtils.isEmpty(salesGoalList)) {
                throw new RuntimeException("未获取到销量任务数据！");
            }
            BigDecimal totalSalesGoalQuantity = salesGoalList.stream().map(SalesGoalVo::getTaskQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            Map<String, BigDecimal> salesGoalMap = salesGoalList.stream().collect(Collectors.toMap(SalesGoalVo::getRegionCode, SalesGoalVo::getTaskQuantity));
            for (MarketingStrategyItemScope scopeVo : result) {
                if (!salesGoalMap.containsKey(scopeVo.getScopeCode())) {
                    continue;
                }
                BigDecimal regionTaskQuantity = salesGoalMap.get(scopeVo.getScopeCode());
                if (regionTaskQuantity.compareTo(BigDecimal.ZERO) <= 0) {
                    continue;
                }
                BigDecimal amount = feeAmount.multiply(regionTaskQuantity).divide(totalSalesGoalQuantity, 6, RoundingMode.HALF_DOWN);
                scopeVo.setSystemShareAmount(amount.toString());
                scopeVo.setSureAmount(scopeVo.getSystemShareAmount());
            }
        }
        //处理尾差
        if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
            MarketingStrategyItemScope lastVo = result.get(result.size() - 1);
            lastVo.setSystemShareAmount(new BigDecimal(lastVo.getSureAmount()).add(leaveAmount).toString());
            lastVo.setSureAmount(lastVo.getSystemShareAmount());
        }
        return result;
    }

    /**
     * 获取总条数
     *
     * @param cacheKey 缓存key
     * @return Integer
     */
    @Override
    public Integer getTotal(String cacheKey) {
        String redisCacheKey = MarketingStrategyConstant.MARKETING_STRATEGY_ITEM_CACHE_KEY_PREFIX+ MnPageCacheConstant.REDIS_KEY_ID+cacheKey;
        return redisService.lSize(redisCacheKey).intValue();
    }

    /**
     * 更据策略明细编码查询策略明细详情
     * @param itemCodes
     * @return
     */
    @Override
    public List<MarketingStrategyItemVo> findByCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        List<MarketingStrategyItemVo> list = this.marketingStrategyItemRepository.findByCodes(itemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    /**
     * 主列表明细导出获取总条数
     * @param dto
     * @return
     */
    @Override
    public Integer itemExportGetTotal(MarketingStrategyItemDto dto) {
        if (Objects.isNull(dto)) {
            return 0;
        }
        dto = Optional.ofNullable(dto).orElse(new MarketingStrategyItemDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return marketingStrategyItemRepository.itemExportGetTotal(dto);
    }

    /**
     * 主列表明细导出获取数据
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Page<MarketStrategyItemExportVo> itemExportGetDate(Pageable pageable, MarketingStrategyItemDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new MarketingStrategyItemDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page<MarketStrategyItemExportVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        return marketingStrategyItemRepository.itemExportGetDate(page,dto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void closeMarketingStrategyItem(List<String> ids) {
//        1. 营销策略增加对于审批通过的策略可允许关闭
//        1.1 策略主列表增加字段“策略状态”
//        策略主列表增加字段“策略状态”，包括：正常，部分关闭，完全关闭
//        策略新增保存数据时，默认赋值“正常”
//        1.2 主列表新增策略关闭功能--对审批通过的策略可选择明细进行关闭
//        1.3 策略明细行新增字段“是否关闭”
//        策略明细行新增字段“是否关闭”：是，否；策略新增时，默认赋值“否”。
//        选中主列表审批状态为审批通过的策略点击【策略关闭】，弹出弹窗展示其下所有的策略明细，弹窗内容如下：
//
//
//
//（1）查询条件：是否关闭、策略明细编码、预算编码、预算项目名称；
//（2）列表字段：是否关闭、策略明细编码、活动分类名称、活动形式名称、一级渠道、二级渠道、品牌、预算编码、预算项目名称、费用归口、预算年月、策略开始时间、策略结束时间、费用金额；
//
//（4）操作按钮：列表数据复选框，取消、确定。
//
//        1.4 勾选策略明细点击确定时，系统进行判定并关闭策略明细：
//        1. 若选中进行关闭的策略明细关联了活动方案且活动方案的审批状态为审批中、审批通过、发起流程时，则不允许被关闭，并给出提示语：该策略明细[策略明细编码]已被活动方案[方案编码]关联，无法关闭。
//        (1) 若选中进行关闭的策略明细未关联活动方案或者关联的活动方案的审批状态为待提交、驳回、追回、关闭时，执行关闭策略明细逻辑并关闭提示框；点击否，不进行策略关闭并关闭提示框，返回上一页。
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        List<MarketingStrategyItem> itemList = marketingStrategyItemRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(itemList)){
            return;
        }
        for (MarketingStrategyItem marketingStrategyItem : itemList) {
            if (BooleanEnum.TRUE.getCapital().equals(marketingStrategyItem.getIsClose())){
                throw new RuntimeException("策略明细["+marketingStrategyItem.getStrategyItemCode()+"]已关闭！");
            }
        }
        List<String> strategyCodeList = itemList.stream().map(MarketingStrategyItem::getStrategyCode).distinct().collect(Collectors.toList());
        List<String> strategyItemCodeList = itemList.stream().map(MarketingStrategyItem::getStrategyItemCode).collect(Collectors.toList());

        MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
        marketingStrategyDto.setStrategyCodeList(strategyCodeList);
        List<MarketingStrategy> strategyList = marketingStrategyRepository.findList(marketingStrategyDto);
        String businessUnitCode = null;
        for (MarketingStrategy strategy : strategyList) {
            if (!ProcessStatusEnum.PASS.getDictCode().equals(strategy.getProcessStatus())){
                throw new RuntimeException("策略["+strategy.getStrategyCode()+"]未审批通过！");
            }
            businessUnitCode = strategy.getBusinessUnitCode();
        }

        //根据策略明细编码查询策略编码
        MarketingStrategyQueryActivityPlanDto queryActivityPlanDto = new MarketingStrategyQueryActivityPlanDto();
        queryActivityPlanDto.setStrategyItemCodeList(strategyItemCodeList);
        SerializableBiConsumer<MarketingStrategyQueryActivityPlanListener, MarketingStrategyQueryActivityPlanDto> queryActivityPlan =
                MarketingStrategyQueryActivityPlanListener::findActivityPlanList;
        MarketingStrategyQueryActivityPlanResponse queryActivityPlanResponse = (MarketingStrategyQueryActivityPlanResponse) this.nebulaNetEventClient.directPublish(queryActivityPlanDto,
                MarketingStrategyQueryActivityPlanListener.class, queryActivityPlan);
        if (null != queryActivityPlanResponse && !CollectionUtils.isEmpty(queryActivityPlanResponse.getPlanList())){
            StringBuilder builder = new StringBuilder();
            for (StrategyActivityPlanItemVo strategyActivityPlanItemVo : queryActivityPlanResponse.getPlanList()) {
                if(BooleanEnum.TRUE.getCapital().equals(strategyActivityPlanItemVo.getIsClose())){
                    continue;//已关闭的不加入校验
                }
                builder.append("策略明细[").append(strategyActivityPlanItemVo.getRelateStrategyItemCode()).append("]已被活动方案[").append(strategyActivityPlanItemVo.getPlanCode()).append("]关联，无法关闭,");
            }
            if (StringUtils.isNotEmpty(builder)){
                throw new RuntimeException(builder.toString());
            }
        }

//        (2) 选择的策略明细被关闭成功后，将明细上的是否关闭变更成“是”，同时作如下判定：
//        (3)     A判定当前所选策略上的策略明细是否全部都已经关闭，如果是，则更新策略主表的策略状态为“完全关闭”，如果所选否则更新主表策略状态为“部分关闭”
        marketingStrategyItemRepository.updateCloseStatus(strategyItemCodeList);
//
//        1.5 策略明细关闭成功后进行预算的处理
//        策略明细关闭成功，退回占用的预算金额：更新关联预算的已使用策略金额、可申请策略金额；
//        1. 已使用策略金额=原已使用策略金额-所关闭策略明细对应的申请金额，
//        2. 可申请策略金额=原可申请策略金额+所关闭策略明细对应的申请金额。
//        1.6 活动方案提交校验逻辑变更
//        状态为待提交、驳回、追回的活动方案进行提交审批时，校验方案关联的所有策略明细是否存在已被关闭的情况，若存在被关闭的策略明细，提示：关联策略明细[策略明细编码]已被关闭，请重新选择可用策略明细。
        List<MarketingStrategyBudget> budgetList = marketingStrategyBudgetRepository.listByStrategyItemCodeList(strategyItemCodeList);
        List<MarketingStrategyBudgetDto> marketingStrategyBudgetDtos = (List<MarketingStrategyBudgetDto>) nebulaToolkitService.copyCollectionByBlankList(budgetList, MarketingStrategyBudget.class, MarketingStrategyBudgetDto.class, HashSet.class, ArrayList.class);
        for (MarketingStrategyBudgetDto marketingStrategyBudgetDto : marketingStrategyBudgetDtos) {
            marketingStrategyBudgetDto.setBusinessUnitCode(businessUnitCode);
        }
        marketingStrategyBudgetService.returnMonthBudget(marketingStrategyBudgetDtos);
    }

}

