package com.biz.crm.tpm.business.marketing.strategy.local.vo;

import com.biz.crm.mn.common.base.util.NumberDealUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * 营销策略审批信息vo
 *
 * @author wanghaojia
 * @date 2022/11/29 20:13
 */
@Data
@ApiModel("营销策略审批信息vo")
public class MarketingStrategyApproveInfoVo {

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目
     */
    @ApiModelProperty(value = "预算项目")
    private String budgetItemName;

    /**
     * 营销策略编码
     */
    @ApiModelProperty(value = "策略编码")
    private String strategyCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    private String strategyOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String strategyOrgName;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    private String firstChannelName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 一月
     */
    @JsonIgnore
    @ApiModelProperty("一月")
    private BigDecimal january;
    @ApiModelProperty("一月")
    private String januaryStr;

    public String getJanuaryStr() {
        if (StringUtils.isNotEmpty(januaryStr)){
            return januaryStr;
        }else if (null != january){
            return january.toString();
        }
        return null;
    }


    /**
     * 二月
     */
    @JsonIgnore
    @ApiModelProperty("二月")
    private BigDecimal february;
    @ApiModelProperty("二月")
    private String februaryStr;

    public String getFebruaryStr() {
        if (StringUtils.isNotEmpty(februaryStr)){
            return februaryStr;
        }else if (null != february){
            return february.toString();
        }
        return null;
    }

    /**
     * 三月
     */
    @JsonIgnore
    @ApiModelProperty("三月")
    private BigDecimal march;
    @ApiModelProperty("三月")
    private String marchStr;

    public String getMarchStr() {
        if (StringUtils.isNotEmpty(marchStr)){
            return marchStr;
        }else if (null != march){
            return march.toString();
        }
        return null;
    }

    /**
     * 四月
     */
    @JsonIgnore
    @ApiModelProperty("四月")
    private BigDecimal april;
    @ApiModelProperty("四月")
    private String aprilStr;

    public String getAprilStr() {
        if (StringUtils.isNotEmpty(aprilStr)){
            return aprilStr;
        }else if (null != april){
            return april.toString();
        }
        return null;
    }

    /**
     * 五月
     */
    @JsonIgnore
    @ApiModelProperty("五月")
    private BigDecimal may;
    @ApiModelProperty("五月")
    private String mayStr;

    public String getMayStr() {
        if (StringUtils.isNotEmpty(mayStr)){
            return mayStr;
        }else if (null != may){
            return may.toString();
        }
        return null;
    }

    /**
     * 六月
     */
    @JsonIgnore
    @ApiModelProperty("六月")
    private BigDecimal june;
    @ApiModelProperty("六月")
    private String juneStr;

    public String getJuneStr() {
        if (StringUtils.isNotEmpty(juneStr)){
            return juneStr;
        }else if (null != june){
            return june.toString();
        }
        return null;
    }

    /**
     * 七月
     */
    @JsonIgnore
    @ApiModelProperty("七月")
    private BigDecimal july;
    @ApiModelProperty("七月")
    private String julyStr;

    public String getJulyStr() {
        if (StringUtils.isNotEmpty(julyStr)){
            return julyStr;
        }else if (null != july){
            return july.toString();
        }
        return null;
    }

    /**
     * 八月
     */
    @JsonIgnore
    @ApiModelProperty("八月")
    private BigDecimal august;
    @ApiModelProperty("八月")
    private String augustStr;

    public String getAugustStr() {
        if (StringUtils.isNotEmpty(augustStr)){
            return augustStr;
        }else if (null != august){
            return august.toString();
        }
        return null;
    }

    /**
     * 九月
     */
    @JsonIgnore
    @ApiModelProperty("九月")
    private BigDecimal september;
    @ApiModelProperty("九月")
    private String septemberStr;

    public String getSeptemberStr() {
        if (StringUtils.isNotEmpty(septemberStr)){
            return septemberStr;
        }else if (null != september){
            return september.toString();
        }
        return null;
    }

    /**
     * 十月
     */
    @JsonIgnore
    @ApiModelProperty("十月")
    private BigDecimal october;
    @ApiModelProperty("十月")
    private String octoberStr;

    public String getOctoberStr() {
        if (StringUtils.isNotEmpty(octoberStr)){
            return octoberStr;
        }else if (null != october){
            return october.toString();
        }
        return null;
    }

    /**
     * 十一月
     */
    @JsonIgnore
    @ApiModelProperty("十一月")
    private BigDecimal november;
    @ApiModelProperty("十一月")
    private String novemberStr;

    public String getNovemberStr() {
        if (StringUtils.isNotEmpty(novemberStr)){
            return novemberStr;
        }else if (null != november){
            return november.toString();
        }
        return null;
    }

    /**
     * 十二月
     */
    @JsonIgnore
    @ApiModelProperty("十二月")
    private BigDecimal december;
    @ApiModelProperty("十二月")
    private String decemberStr;

    public String getDecemberStr() {
        if (StringUtils.isNotEmpty(decemberStr)){
            return decemberStr;
        }else if (null != december){
            return december.toString();
        }
        return null;
    }

    /**
     * 合计
     */
    @ApiModelProperty("合计")
    public BigDecimal getFeeAmount() {
        return NumberDealUtil.decimalSum(january,february,march,april,may,june,july,august,september,october,november,december);
    }

}
