package com.biz.crm.tpm.business.marketing.strategy.local.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 营销策略审批信息vo
 *
 * @author wanghaojia
 * @date 2022/11/29 20:13
 */
@Data
@ApiModel("营销策略审批流程汇总信息vo")
public class MarketingStrategyApproveProcessSumInfoVo {

    /**
     * 预算项目
     */
    private String budgetItemCode;
    /**
     * 预算项目
     */
    private String budgetItemName;
    /**
     * 部门编码
     */
    private String orgCode;
    /**
     * 部门名称
     */
    private String orgName;
    /**
     * 年月
     */
    private String yearMonthLy;
    /**
     * 累计滚动金额（元）
     */
    private BigDecimal rollingAmount;
    /**
     * 已使用策略金额（元）
     */
    private BigDecimal usedStrategyAmount;
    /**
     * 本次策略金额
     */
    @ApiModelProperty(value = "本次策略金额", notes = "")
    private BigDecimal totalStrategyAmount;

}
