package com.biz.crm.tpm.business.marketing.strategy.local.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 营销策略提交审批VO
 * @author wanghaojia
 * @date 2022/11/29 19:51
 */
@Data
@ApiModel("营销策略审批信息查询vo")
public class MarketingStrategyApproveVo {

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;

    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    private String attrOrgCode;

    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门名称")
    private String attrOrgName;
    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型,数据字典：marketing_strategy_type")
    private String strategyType;

    /**
     * 策略年度
     */
    @ApiModelProperty("策略年度")
    private String strategyYear;


}
