package com.biz.crm.tpm.business.marketing.strategy.local.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 预算汇总信息
 */
@Data
@ApiModel("营销策略预算汇总信息")
public class MarketingStrategyBudgetSumVo {

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;


    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;


    /**
     * 年初分解金额（期初金额）
     */
    @ApiModelProperty(value = "年初分解金额（期初金额）", notes = "")
    private BigDecimal initResolveAmount;

    /**
     * 月度滚动金额
     */
    @ApiModelProperty(value = "月度滚动金额", notes = "")
    private BigDecimal monthRollingAmount;

    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "上月滚动金额")
    private BigDecimal lastMonthRollingAmount;
    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "冻结后可用金额")
    private BigDecimal afterFreezeAmount;

    /**
     * 本次策略金额
     */
    @ApiModelProperty(value = "本次策略金额", notes = "")
    private BigDecimal totalStrategyAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 可申请策略金额
     */
    @ApiModelProperty(value = "可申请策略金额", notes = "")
    private BigDecimal canApplyStrategyAmount;

}
