package com.biz.crm.tpm.business.platform.customer.local.controller;


import com.biz.crm.tpm.business.platform.customer.sdk.service.PlatformCustomerService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 平台客户(PlatformCustomerDto)表相关的http接口
 *
 * @author yaoyongming
 * @since 2022-12-05 15:44:07
 */
@RestController
@RequestMapping("/v1/platformCustomer")
@Slf4j
@Api(tags = "平台客户")
public class PlatformCustomerController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private PlatformCustomerService platformCustomerService;

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<PlatformCustomerDto> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            PlatformCustomerDto platformCustomer = this.platformCustomerService.findById(id);
            return Result.ok(platformCustomer);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param platformCustomer 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<PlatformCustomerDto> create(@ApiParam(name = "platformCustomer", value = "平台客户") @RequestBody PlatformCustomerDto platformCustomer) {
        try {
            PlatformCustomerDto result = this.platformCustomerService.create(platformCustomer);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param platformCustomer 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<PlatformCustomerDto> update(@ApiParam(name = "platformCustomer", value = "平台客户") @RequestBody PlatformCustomerDto platformCustomer) {
        try {
            PlatformCustomerDto result = this.platformCustomerService.update(platformCustomer);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PatchMapping("enable")
    public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
        try {
            this.platformCustomerService.enableBatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("disable")
    public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
        try {
            this.platformCustomerService.disableBatch(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.platformCustomerService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
