package com.biz.crm.tpm.business.platform.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 平台客户
 *
 * @author: yaoyongming
 * @date: 2022/12/5 13:36
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PlatformCustomer", description = "平台客户")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_platform_customer`", comment = "平台客户")
@TableName("tpm_platform_customer")
@Table(
        name = "`tpm_platform_customer`",
        indexes = {
                @Index(name = "uk_tpm_platform_customer1", columnList = "platform_customer_code", unique = true)
        })
public class PlatformCustomer extends TenantFlagOpEntity {

    /**
     * 平台客户编码
     */
    @ApiModelProperty("平台客户编码")
    @Column(name = "platform_customer_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '平台客户编码'")
    private String platformCustomerCode;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '平台编码'")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    @Column(name = "platform_name", columnDefinition = "VARCHAR(255) COMMENT '平台名称'")
    private String platformName;

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    @Column(name = "shop", length = 128, columnDefinition = "VARCHAR(128) COMMENT '店铺名称'")
    private String shop;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", columnDefinition = "VARCHAR(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * appKey
     */
    @ApiModelProperty("appKey")
    @Column(name = "app_key", length = 2000, columnDefinition = "VARCHAR(2000) COMMENT 'appKey'")
    private String appKey;

    /**
     * appSecret
     */
    @ApiModelProperty("appSecret")
    @Column(name = "app_secret", length = 2000, columnDefinition = "VARCHAR(2000) COMMENT 'appSecret'")
    private String appSecret;

    /**
     * 授权url
     */
    @ApiModelProperty("授权url")
    @Column(name = "url", columnDefinition = "VARCHAR(255) COMMENT '授权url'")
    private String url;
}
