package com.biz.crm.tpm.business.platform.customer.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.platform.customer.local.entity.PlatformCustomer;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerExportDto;
import com.biz.crm.tpm.business.platform.customer.sdk.vo.PlatformCustomerExportsVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 平台客户(PlatformCustomer)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-12-05 15:44:09
 */
public interface PlatformCustomerMapper extends BaseMapper<PlatformCustomer> {

    /**
     * 分页查询所有数据
     *
     * @param page             分页对象
     * @param platformCustomer 查询实体
     * @return 所有数据
     */
    Page<PlatformCustomer> findByConditions(@Param("page") Page<PlatformCustomer> page, @Param("platformCustomer") PlatformCustomer platformCustomer);

    /**
     * 获取匹配的数据总量
     *
     * @param dto
     * @return
     */
    Integer getExportTotal(@Param("dto") PlatformCustomerExportDto dto);

    /**
     * 获取导出数据
     *
     * @param dto
     * @return
     */
    List<PlatformCustomerExportsVo> findData(@Param("dto") PlatformCustomerExportDto dto);
}

