package com.biz.crm.tpm.business.platform.customer.local.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.platform.customer.local.constant.PlatformCustomerConstant;
import com.biz.crm.tpm.business.platform.customer.local.mapper.PlatformCustomerMapper;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerExportDto;
import com.biz.crm.tpm.business.platform.customer.sdk.vo.PlatformCustomerExportsVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 导出
 *
 * @author: yaoyongming
 * @date: 2022/12/12 17:05
 */
@Component
public class PlatformCustomerExportsProcess implements ExportProcess<PlatformCustomerExportsVo> {

    @Autowired(required = false)
    private PlatformCustomerMapper platformCustomerMapper;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    /**
     * 获取总条数
     *
     * @param params
     * @return
     */
    @Override
    public Integer getTotal(Map<String, Object> params) {
        PlatformCustomerExportDto dto = this.convertParams(params);

        Integer total = platformCustomerMapper.getExportTotal(dto);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    /**
     * 获取数据
     *
     * @param vo
     * @param params
     * @return
     */
    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        PlatformCustomerExportDto dto = this.convertParams(params);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<PlatformCustomerExportsVo> data = platformCustomerMapper.findData(dto);
        //调整
        adjustData(data);
        return JSON.parseArray(JSON.toJSONString(data));
    }

    /**
     * 模板编码
     *
     * @return
     */
    @Override
    public String getBusinessCode() {
        return "TPM_PLATFORM_CUSTOMER_EXPORT";
    }

    /**
     * 模板名称
     *
     * @return
     */
    @Override
    public String getBusinessName() {
        return "TPM平台客户导出";
    }

    /**
     * 获取参数
     *
     * @param params
     * @return
     */
    private PlatformCustomerExportDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        PlatformCustomerExportDto dto = JSON.parseObject(JSON.toJSONString(params), PlatformCustomerExportDto.class);
        return dto;
    }

    /**
     * 调整数据
     *
     * @param data
     */
    private void adjustData(List<PlatformCustomerExportsVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(PlatformCustomerConstant.ENABLE_STATUS));
        for (PlatformCustomerExportsVo vo : data) {
            vo.setEnableStatus(this.findDictValue(mapDict, PlatformCustomerConstant.ENABLE_STATUS, String.valueOf(vo.getEnableStatus())));
        }
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    @Override
    public Class<PlatformCustomerExportsVo> findCrmExcelVoClass() {
        return PlatformCustomerExportsVo.class;
    }
}
