package com.biz.crm.tpm.business.platform.customer.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author yaoyongming
 * @create 2022-12-05 11:21
 */
@Component
@Slf4j
public class PlatformCustomerRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_platform_customer_data_view";
    }

    @Override
    public String desc() {
        return "TPM-平台客户模板";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_platform_customer t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
