package com.biz.crm.tpm.business.platform.customer.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.platform.customer.local.entity.PlatformCustomer;
import com.biz.crm.tpm.business.platform.customer.local.mapper.PlatformCustomerMapper;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 * 平台客户(PlatformCustomer)表数据库访问层
 *
 * @author yaoyongming
 * @since 2022-12-05 15:44:09
 */
@Component
public class PlatformCustomerRepository extends ServiceImpl<PlatformCustomerMapper, PlatformCustomer> {

    @Autowired(required = false)
    private PlatformCustomerMapper platformCustomerMapper;

    /**
     * 按id批量逻辑删除
     *
     * @param idList
     */
    public void removePlatformCustomerByIds(List<String> idList) {
        this.lambdaUpdate().in(PlatformCustomer::getId, idList).set(PlatformCustomer::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    /**
     * 根据主键集合，修改 enable_status
     *
     * @param enable
     * @param ids
     */
    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper<PlatformCustomer> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("enable_status", enable.getCode());
        updateWrapper.in("id", ids);
        this.update(updateWrapper);
    }
    
    /**
     * 查询是否存在数据并返回存在数据的id
     * @param dto
     * @return
     */
    public List<PlatformCustomer> findOnCreate(PlatformCustomerDto dto) {
        return this.lambdaQuery().eq(PlatformCustomer::getPlatformCode, dto.getPlatformCode())
                .eq(PlatformCustomer::getCustomerCode, dto.getCustomerCode())
                .eq(PlatformCustomer::getShop, dto.getShop())
                .eq(PlatformCustomer::getAppKey, dto.getAppKey())
                .eq(PlatformCustomer::getAppSecret, dto.getAppSecret())
                .eq(PlatformCustomer::getUrl, dto.getUrl())
                .eq(PlatformCustomer::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .select(PlatformCustomer::getId).list();
    }

    /**
     * 查询是否存在数据并返回存在数据的id
     * @param dto
     * @return
     */
    public List<PlatformCustomer> findOnUpdate(PlatformCustomerDto dto) {
        return this.lambdaQuery().eq(PlatformCustomer::getPlatformCode, dto.getPlatformCode())
                .eq(PlatformCustomer::getCustomerCode, dto.getCustomerCode())
                .eq(PlatformCustomer::getShop, dto.getShop())
                .eq(PlatformCustomer::getAppKey, dto.getAppKey())
                .eq(PlatformCustomer::getAppSecret, dto.getAppSecret())
                .eq(PlatformCustomer::getUrl, dto.getUrl())
                .eq(PlatformCustomer::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .ne(PlatformCustomer::getId, dto.getId())
                .select(PlatformCustomer::getId).list();
    }
}

