package com.biz.crm.tpm.business.platform.customer.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;


/**
 * 平台客户dto
 *
 * @author: yaoyongming
 * @date: 2022/12/5 15:59
 */
@Getter
@Setter
@ApiModel(value = "PlatformCustomerDto", description = "平台客户dto")
public class PlatformCustomerDto extends TenantFlagOpDto {
    /**
     * 平台客户编码
     */
    @ApiModelProperty("平台客户编码")
    private String platformCustomerCode;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    private String platformName;

    /**
     * 店铺名称
     */
    @ApiModelProperty("店铺名称")
    private String shop;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * appKey
     */
    @ApiModelProperty("appKey")
    private String appKey;

    /**
     * appSecret
     */
    @ApiModelProperty("appSecret")
    private String appSecret;

    /**
     * 授权url
     */
    @ApiModelProperty("授权url")
    private String url;
}
