package com.biz.crm.tpm.business.platform.customer.sdk.event.log;

import com.biz.crm.tpm.business.platform.customer.sdk.dto.log.PlatformCustomerLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 日志监听
 */
public interface PlatformCustomerLogEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(PlatformCustomerLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(PlatformCustomerLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(PlatformCustomerLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(PlatformCustomerLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(PlatformCustomerLogEventDto eventDto);
}
